/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IIndexWordID;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.IndexWordID;
import edu.mit.jwi.item.POS;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IndexWord
implements IIndexWord {
    private final IIndexWordID id;
    private final int tagSenseCount;
    private final List<IWordID> wordIDs;

    public IndexWord(String lemma, POS pos, int tagSenseCnt, IWordID ... words) {
        this(new IndexWordID(lemma, pos), tagSenseCnt, words);
    }

    public IndexWord(IIndexWordID id, int tagSenseCnt, IWordID ... words) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (tagSenseCnt < 0) {
            throw new IllegalArgumentException();
        }
        if (words.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IWordID wid : words) {
            if (wid != null) continue;
            throw new NullPointerException();
        }
        this.id = id;
        this.tagSenseCount = tagSenseCnt;
        this.wordIDs = Collections.unmodifiableList(Arrays.asList(words));
    }

    @Override
    public String getLemma() {
        return this.id.getLemma();
    }

    @Override
    public List<IWordID> getWordIDs() {
        return this.wordIDs;
    }

    @Override
    public int getTagSenseCount() {
        return this.tagSenseCount;
    }

    @Override
    public IIndexWordID getID() {
        return this.id;
    }

    @Override
    public POS getPOS() {
        return this.id.getPOS();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.id.getLemma());
        sb.append(" (");
        sb.append((Object)this.id.getPOS());
        sb.append(") ");
        Iterator<IWordID> i = this.wordIDs.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.tagSenseCount;
        result = 31 * result + ((Object)this.wordIDs).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IIndexWord)) {
            return false;
        }
        IndexWord other = (IndexWord)obj;
        if (!this.id.equals(other.getID())) {
            return false;
        }
        if (this.tagSenseCount != other.getTagSenseCount()) {
            return false;
        }
        return ((Object)this.wordIDs).equals(other.getWordIDs());
    }
}

