/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class TokenNameFinderFactory
extends BaseToolFactory {
    private byte[] featureGeneratorBytes;
    private Map<String, Object> resources;
    private SequenceCodec<String> seqCodec;

    public TokenNameFinderFactory() {
        this.seqCodec = new BioCodec();
    }

    public TokenNameFinderFactory(byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> seqCodec) {
        this.init(featureGeneratorBytes, resources, seqCodec);
    }

    void init(byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> seqCodec) {
        this.featureGeneratorBytes = featureGeneratorBytes;
        this.resources = resources;
        this.seqCodec = seqCodec;
    }

    private static byte[] loadDefaultFeatureGeneratorBytes() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (InputStream in = TokenNameFinderFactory.class.getResourceAsStream("/opennlp/tools/namefind/ner-default-features.xml");){
            int len;
            if (in == null) {
                throw new IllegalStateException("Classpath must contain ner-default-features.xml file!");
            }
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                bytes.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed reading from ner-default-features.xml file on classpath!");
        }
        return bytes.toByteArray();
    }

    protected SequenceCodec<String> getSequenceCodec() {
        return this.seqCodec;
    }

    protected Map<String, Object> getResources() {
        return this.resources;
    }

    protected byte[] getFeatureGenerator() {
        return this.featureGeneratorBytes;
    }

    public static TokenNameFinderFactory create(String subclassName, byte[] featureGeneratorBytes, Map<String, Object> resources, SequenceCodec<String> seqCodec) throws InvalidFormatException {
        TokenNameFinderFactory theFactory;
        if (subclassName == null) {
            theFactory = new TokenNameFinderFactory();
        } else {
            try {
                theFactory = ExtensionLoader.instantiateExtension(TokenNameFinderFactory.class, subclassName);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + subclassName + ". The initialization throw an exception.";
                System.err.println(msg);
                e.printStackTrace();
                throw new InvalidFormatException(msg, e);
            }
        }
        theFactory.init(featureGeneratorBytes, resources, seqCodec);
        return theFactory;
    }

    @Override
    public void validateArtifactMap() throws InvalidFormatException {
    }

    public SequenceCodec<String> createSequenceCodec() {
        if (this.artifactProvider != null) {
            String sequeceCodecImplName = this.artifactProvider.getManifestProperty("sequenceCodecImplName");
            return TokenNameFinderFactory.instantiateSequenceCodec(sequeceCodecImplName);
        }
        return this.seqCodec;
    }

    public NameContextGenerator createContextGenerator() {
        AdaptiveFeatureGenerator featureGenerator = this.createFeatureGenerators();
        if (featureGenerator == null) {
            featureGenerator = new CachedFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenFeatureGenerator(), 2, 2), new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenClassFeatureGenerator(true), 2, 2), new OutcomePriorFeatureGenerator(), new PreviousMapFeatureGenerator(), new BigramNameFeatureGenerator(), new SentenceFeatureGenerator(true, false));
        }
        return new DefaultNameContextGenerator(featureGenerator);
    }

    public AdaptiveFeatureGenerator createFeatureGenerators() {
        AdaptiveFeatureGenerator generator;
        if (this.featureGeneratorBytes == null && this.artifactProvider != null) {
            this.featureGeneratorBytes = (byte[])this.artifactProvider.getArtifact("generator.featuregen");
        }
        if (this.featureGeneratorBytes == null) {
            this.featureGeneratorBytes = TokenNameFinderFactory.loadDefaultFeatureGeneratorBytes();
        }
        ByteArrayInputStream descriptorIn = new ByteArrayInputStream(this.featureGeneratorBytes);
        try {
            generator = GeneratorFactory.create(descriptorIn, (String key) -> {
                if (this.artifactProvider != null) {
                    return this.artifactProvider.getArtifact(key);
                }
                return this.resources.get(key);
            });
        }
        catch (InvalidFormatException e) {
            throw new TokenNameFinderModel.FeatureGeneratorCreationError(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading from mem cannot result in an I/O error", e);
        }
        return generator;
    }

    public static SequenceCodec<String> instantiateSequenceCodec(String sequenceCodecImplName) {
        if (sequenceCodecImplName != null) {
            return ExtensionLoader.instantiateExtension(SequenceCodec.class, sequenceCodecImplName);
        }
        return new BioCodec();
    }
}

