/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.parameter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterHolder;
import org.apache.log4j.Logger;
import org.apache.uima.fit.descriptor.ConfigurationParameter;

public final class ParameterTableModel
implements TableModel {
    private static final Logger LOGGER = Logger.getLogger((String)"ParameterTableModel");
    private static final String[] COLUMN_NAMES = new String[]{"Parameter Name", "Value", ""};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{ConfigurationParameter.class, String.class, File.class};
    private final EventListenerList _listenerList = new EventListenerList();
    private ParameterHolder _parameterHolder;
    private List<String[]> _values = new ArrayList<String[]>();

    public ParameterHolder getParameterHolder() {
        return this._parameterHolder;
    }

    public void setParameterHolder(ParameterHolder holder) {
        int oldSize = this._parameterHolder == null ? 0 : this._parameterHolder.getParameterCount();
        this._parameterHolder = holder;
        this._values.clear();
        if (holder == null) {
            if (oldSize > 0) {
                this.fireTableChanged(new TableModelEvent(this, 0, oldSize - 1, -1, -1));
            }
            return;
        }
        for (int i = 0; i < holder.getParameterCount(); ++i) {
            this._values.add(holder.getParameterValue(i));
        }
        if (holder.getParameterCount() > 0) {
            this.fireTableChanged(new TableModelEvent(this));
        } else if (oldSize > 0) {
            this.fireTableChanged(new TableModelEvent(this, 0, oldSize - 1, -1, -1));
        }
    }

    public List<String[]> getValues() {
        return Collections.unmodifiableList(this._values);
    }

    @Override
    public int getRowCount() {
        if (this._parameterHolder == null) {
            return 0;
        }
        return this._parameterHolder.getParameterCount();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this._parameterHolder.getParameter(rowIndex);
            }
            case 1: {
                return Arrays.stream((Object[])this._values.get(rowIndex)).filter(v -> !"org.apache.uima.fit.descriptor.ConfigurationParameter.NO_DEFAULT_VALUE".equals(v)).collect(Collectors.joining(" , "));
            }
            case 2: {
                String path = Arrays.stream((Object[])this._values.get(rowIndex)).filter(v -> !"org.apache.uima.fit.descriptor.ConfigurationParameter.NO_DEFAULT_VALUE".equals(v)).collect(Collectors.joining("/"));
                return new File(path);
            }
        }
        return "ERROR";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this._values.set(rowIndex, aValue.toString().split(","));
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex));
        } else if (columnIndex == 2 && File.class.isInstance(aValue)) {
            String[] path = new String[]{((File)aValue).getPath()};
            this._values.set(rowIndex, path);
            this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, 1));
        }
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this._listenerList.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this._listenerList.remove(TableModelListener.class, listener);
    }

    private void fireTableChanged(TableModelEvent event) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(event);
        }
    }
}

