/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public final class FileChooserPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"FileChooserPanel");

    public FileChooserPanel(String name, String defaultDirectory, ActionListener fileChangeListener) {
        this(name, defaultDirectory, false, fileChangeListener);
    }

    public FileChooserPanel(String name, String defaultDirectory, boolean selectDir, ActionListener fileChangeListener) {
        super(new BorderLayout(10, 10));
        this.setBorder(new EmptyBorder(2, 10, 2, 10));
        JLabel label = new JLabel(name);
        label.setPreferredSize(new Dimension(100, 0));
        label.setHorizontalAlignment(11);
        JTextField textField = new JTextField(defaultDirectory);
        textField.setEditable(false);
        JButton openChooserButton = new JButton(new OpenFileChooserAction(textField, selectDir, fileChangeListener));
        this.add((Component)label, "West");
        this.add((Component)textField, "Center");
        this.add((Component)openChooserButton, "East");
        textField.setDropTarget(new FileDropTarget(textField, selectDir, fileChangeListener));
        textField.addActionListener(fileChangeListener);
    }

    private static class FileDropTarget
    extends DropTarget {
        private final JTextComponent __textComponent;
        private final ActionListener __fileChangeListener;
        private final boolean __selectDir;

        private FileDropTarget(JTextComponent textComponent, boolean selectDir, ActionListener dirChangeListener) {
            this.__textComponent = textComponent;
            this.__selectDir = selectDir;
            this.__fileChangeListener = dirChangeListener;
        }

        @Override
        public synchronized void drop(DropTargetDropEvent event) {
            event.acceptDrop(1);
            try {
                Object values = event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (!(values instanceof Iterable)) {
                    return;
                }
                for (Object value : (Iterable)values) {
                    File file;
                    if (!(value instanceof File) || (file = (File)value).isDirectory() != this.__selectDir) continue;
                    this.__textComponent.setText(file.getAbsolutePath());
                    ActionEvent fileEvent = new ActionEvent(this, 1001, file.getAbsolutePath());
                    this.__fileChangeListener.actionPerformed(fileEvent);
                    return;
                }
            }
            catch (UnsupportedFlavorException | IOException multE) {
                LOGGER.warn((Object)multE.getMessage());
            }
        }
    }

    private static class OpenFileChooserAction
    extends AbstractAction {
        private final JFileChooser __chooser;
        private final JTextComponent __textComponent;
        private final ActionListener __fileChangeListener;

        private OpenFileChooserAction(JTextComponent textComponent, boolean selectDir, ActionListener dirChangeListener) {
            super("Select " + (selectDir ? "Directory" : "File"));
            this.__textComponent = textComponent;
            this.__chooser = new JFileChooser();
            this.__chooser.setFileSelectionMode(selectDir ? 1 : 0);
            this.__fileChangeListener = dirChangeListener;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int option;
            File startingDir;
            String startDirPath = this.__textComponent.getText();
            if (startDirPath != null && !startDirPath.isEmpty() && (startingDir = new File(startDirPath)).exists()) {
                this.__chooser.setCurrentDirectory(startingDir);
            }
            if ((option = this.__chooser.showOpenDialog(null)) != 0) {
                return;
            }
            File file = this.__chooser.getSelectedFile();
            this.__textComponent.setText(file.getAbsolutePath());
            ActionEvent fileEvent = new ActionEvent(this, 1001, file.getAbsolutePath());
            this.__fileChangeListener.actionPerformed(fileEvent);
        }
    }
}

