/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgGlobal;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.OutputOptionDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.ViewLexItemsDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OutputPanel
extends JPanel {
    private static final String LVG_BANNER = "*** Welcome to Lexical Tool ***";
    private static Vector<String> banner_ = new Vector();
    private static JList<String> lvgOutputs_ = null;
    private static JFrame owner_ = null;
    private static OutputPanel outputP_ = null;
    private static final long serialVersionUID = 5L;

    private OutputPanel(JFrame owner) {
        owner_ = owner;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Outputs"));
        JScrollPane scrollPane = new JScrollPane(lvgOutputs_);
        JButton optionB = new JButton("Options");
        JButton resetB = new JButton("Reset");
        JButton detailB = new JButton("Details");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 3, 5, 3);
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 1, 1, 5, 1);
        this.add((Component)scrollPane, gbc);
        gbc.fill = 0;
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 2, 2, 1, 1);
        this.add((Component)optionB, gbc);
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 3, 2, 1, 1);
        this.add((Component)resetB, gbc);
        gbc.anchor = 17;
        GridBag.SetPosSize(gbc, 4, 2, 1, 1);
        this.add((Component)detailB, gbc);
        optionB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.ShowDialog(owner_);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                lvgOutputs_.setListData(banner_);
            }
        });
        detailB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = lvgOutputs_.getSelectedIndex();
                Vector<LexItem> outputs = LvgGlobal.GetOutputLexItems();
                ViewLexItemsDialog lexItemD = new ViewLexItemsDialog(owner_, outputs, "LVG Output - LexItems Details", "Output LexItems Deatils", index);
                lexItemD.setVisible(true);
            }
        });
    }

    public static JPanel GetPanel(JFrame owner) {
        if (outputP_ == null) {
            outputP_ = new OutputPanel(owner);
        }
        return outputP_;
    }

    public static void UpdateResult() {
        Vector<String> outStrs = LvgGlobal.GetOutputStrings();
        if (outStrs.size() == 0) {
            lvgOutputs_.setListData(banner_);
        } else {
            lvgOutputs_.setListData(outStrs);
            lvgOutputs_.setSelectedIndex(0);
        }
    }

    public static void SetSelectedIndex(int index) {
        lvgOutputs_.setSelectedIndex(index);
    }

    public static JList<String> GetOutputList() {
        return lvgOutputs_;
    }

    public static void SetOutputMessage() {
        String msg = "*** Results are sent to the file below ***";
        Vector<String> msgList_ = new Vector<String>();
        msgList_.addElement(msg);
        msgList_.addElement("    '" + LvgGlobal.outFile_.getPath() + "'");
        GregorianCalendar cal = new GregorianCalendar();
        msgList_.addElement("    @ " + cal.getTime().toString());
        lvgOutputs_.setListData(msgList_);
    }

    static {
        banner_.addElement(LVG_BANNER);
        lvgOutputs_ = new JList<String>(banner_);
        lvgOutputs_.setFont(new Font("Dialog", 0, 14));
    }
}

