/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Vector;

public class ToSimpleInflections
extends Transformation
implements Cloneable {
    private static final String INFO = "Simple Inflections";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        ToSimpleInflections.GetSimpleInflectionsFromSource(in);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
            mutate = in.GetSourceInflection().GetName() + fs + in.GetSourceInflection().GetValue() + fs;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToSimpleInflections.UpdateLexItem(in, in.GetSourceTerm(), 50, in.GetTargetCategory().GetValue(), in.GetTargetInflection().GetValue(), details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToSimpleInflections.GetTestStr(args, "AIDS");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToSimpleInflections.Mutate(in, true, true);
        ToSimpleInflections.PrintResults(in, outs);
    }

    public static void GetSimpleInflectionsOnTarget(LexItem in) {
        in.SetTargetInflection(ToSimpleInflections.GetSimpleInflections(in.GetTargetInflection().GetValue()));
    }

    private static void GetSimpleInflectionsFromSource(LexItem in) {
        in.SetTargetCategory(in.GetSourceCategory().GetValue());
        in.SetTargetInflection(ToSimpleInflections.GetSimpleInflections(in.GetSourceInflection().GetValue()));
    }

    private static long GetSimpleInflections(long infl) {
        long simpleInfl = infl;
        for (int i = 8; i < 24; ++i) {
            if ((infl & BitMaskBase.MASK[i]) != BitMaskBase.MASK[i]) continue;
            simpleInfl = Bit.Minus(simpleInfl, BitMaskBase.MASK[i]);
            simpleInfl = Bit.Add(simpleInfl, Inflection.MAP_SIMPLE_INFL[i]);
        }
        return simpleInfl;
    }
}

