/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRetrieveCatInfl
extends Transformation
implements Cloneable {
    private static final String INFO = "Retrieve Cat Infl";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<InflectionRecord> catInflRec = ToRetrieveCatInfl.GetCatInfl(in.GetSourceTerm(), conn);
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<InflectionRecord> combined = new Vector<InflectionRecord>();
        for (int i = 0; i < catInflRec.size(); ++i) {
            InflectionRecord record = catInflRec.elementAt(i);
            ToRetrieveCatInfl.AddRecordToCombined(record, combined, inCat, inInfl);
        }
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < combined.size(); ++i) {
            InflectionRecord record = combined.elementAt(i);
            String term = record.GetInflectedTerm();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
                mutate = "FACT" + fs + Category.ToName(record.GetCategory()) + fs + Inflection.ToName(record.GetInflection()) + fs;
            }
            LexItem temp = ToRetrieveCatInfl.UpdateLexItem(in, term, 25, record.GetCategory(), record.GetInflection(), details, mutate);
            out.addElement(temp);
        }
        if (out.size() == 0) {
            CatInfl catInfl = trie.GetCatInflByRules(in.GetSourceTerm(), inCat, inInfl);
            String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
            String mutate = "RULE" + fs + catInfl.GetCategoryStr() + fs + catInfl.GetInflectionStr() + fs;
            LexItem temp = ToRetrieveCatInfl.UpdateLexItem(in, in.GetSourceTerm(), 25, catInfl.GetCategory(), catInfl.GetInflection(), INFO, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToRetrieveCatInfl.GetTestStr(args, "bloom");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToRetrieveCatInfl.Mutate(in, conn, trie, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToRetrieveCatInfl.PrintResults(in, outs);
    }

    private static void AddRecordToCombined(InflectionRecord record, Vector<InflectionRecord> combined, long inCat, long inInfl) {
        long curInfl;
        long curCat = record.GetCategory();
        if (!InputFilter.IsLegal(inCat, inInfl, curCat, curInfl = record.GetInflection())) {
            return;
        }
        if (combined.size() == 0) {
            combined.addElement(record);
        } else {
            boolean recordExist = false;
            for (int i = 0; i < combined.size(); ++i) {
                InflectionRecord cur = combined.elementAt(i);
                if (!cur.GetInflectedTerm().equalsIgnoreCase(record.GetInflectedTerm())) continue;
                recordExist = true;
                cur.SetCategory(Bit.Add(cur.GetCategory(), (int)curCat));
                cur.SetInflection(Bit.Add(cur.GetInflection(), curInfl));
                break;
            }
            if (!recordExist) {
                combined.addElement(record);
            }
        }
    }

    private static Vector<InflectionRecord> GetCatInfl(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflection.GetCatInfl(inStr, conn);
        return out;
    }
}

