/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.ToSimpleInflections;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.TermCatInflKey;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;

public class ToInflectionSimple
extends Transformation
implements Cloneable {
    private static final String INFO = "Inflection Simple";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> infls = ToInflection.Mutate(in, conn, trie, restrictFlag, detailsFlag, mutateFlag);
        Hashtable<TermCatInflKey, LexItem> ht = new Hashtable<TermCatInflKey, LexItem>(infls.size());
        String flowName = Flow.GetBitName(51, 1);
        for (int i = 0; i < infls.size(); ++i) {
            LexItem curIn = infls.elementAt(i);
            ToSimpleInflections.GetSimpleInflectionsOnTarget(curIn);
            String oldHistory = curIn.GetFlowHistory();
            String flowHistory = oldHistory.substring(0, oldHistory.length() - 1) + flowName;
            curIn.SetFlowHistory(flowHistory);
            TermCatInflKey curKey = new TermCatInflKey(curIn.GetTargetTerm(), (int)curIn.GetTargetCategory().GetValue(), curIn.GetTargetInflection().GetValue());
            ht.put(curKey, curIn);
        }
        Vector<LexItem> outs = new Vector<LexItem>(ht.values());
        return outs;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToInflectionSimple.GetTestStr(args, "Left");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn == null) {
                System.err.println("** Error: Db connection problem!");
            }
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToInflectionSimple.Mutate(in, conn, trie, 2, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToInflectionSimple.PrintResults(in, outs);
    }
}

