/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.weka;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import org.apache.ctakes.ytex.kernel.AbstractBagOfWordsExporter;
import org.apache.ctakes.ytex.kernel.BagOfWordsData;
import org.apache.ctakes.ytex.kernel.BagOfWordsDecorator;
import org.apache.ctakes.ytex.weka.WekaBagOfWordsExporter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;

public class WekaBagOfWordsExporterImpl
extends AbstractBagOfWordsExporter
implements WekaBagOfWordsExporter {
    private static final String INSTANCE_ID = "instance_id";
    private static final String CLASS = "ytex_class";

    private void addWordsToInstances(Instances instances, BagOfWordsData bagOfWordsData) throws IOException {
        for (Map.Entry<Integer, String> entry : bagOfWordsData.getDocumentClasses().entrySet()) {
            Attribute wordAttr;
            double[] zeroValues = new double[instances.numAttributes()];
            Arrays.fill(zeroValues, 0.0);
            SparseInstance wekaInstance = new SparseInstance(1.0, zeroValues);
            wekaInstance.setDataset(instances);
            Attribute instanceId = instances.attribute(INSTANCE_ID);
            wekaInstance.setValue(instanceId.index(), entry.getKey().doubleValue());
            Attribute classAttr = instances.attribute(CLASS);
            wekaInstance.setValue(classAttr.index(), (double)classAttr.indexOfValue(entry.getValue()));
            if (bagOfWordsData.getInstanceNumericWords().get(entry.getKey()) != null) {
                for (Map.Entry<String, Double> entry2 : bagOfWordsData.getInstanceNumericWords().get(entry.getKey()).entrySet()) {
                    wordAttr = instances.attribute(entry2.getKey());
                    wekaInstance.setValue(wordAttr.index(), entry2.getValue().doubleValue());
                }
            }
            if (bagOfWordsData.getInstanceNominalWords().get(entry.getKey()) != null) {
                for (Map.Entry<String, Object> entry3 : bagOfWordsData.getInstanceNominalWords().get(entry.getKey()).entrySet()) {
                    wordAttr = instances.attribute(entry3.getKey());
                    int valueIndex = wordAttr.indexOfValue((String)entry3.getValue());
                    if (valueIndex == -1) {
                        throw new IOException("oops! " + entry3);
                    }
                    wekaInstance.setValue(wordAttr.index(), (double)valueIndex);
                }
            }
            instances.add((Instance)wekaInstance);
        }
    }

    @Override
    public void exportBagOfWords(String arffRelation, String instanceClassQuery, String instanceNumericWordQuery, String instanceNominalWordQuery, BufferedWriter writer) throws IOException {
        this.exportBagOfWords(arffRelation, instanceClassQuery, instanceNumericWordQuery, instanceNominalWordQuery, writer, null);
    }

    public void exportBagOfWords(String arffRelation, String instanceClassQuery, String instanceNumericWordQuery, String instanceNominalWordQuery, BufferedWriter writer, BagOfWordsDecorator bDecorator) throws IOException {
        BagOfWordsData bagOfWordsData = new BagOfWordsData();
        this.getInstances(instanceClassQuery, bagOfWordsData);
        this.loadData(bagOfWordsData, instanceNumericWordQuery, instanceNominalWordQuery, bDecorator);
        Instances instances = this.initializeInstances(arffRelation, bagOfWordsData, bDecorator);
        this.addWordsToInstances(instances, bagOfWordsData);
        writer.write(instances.toString());
    }

    @Override
    public void exportBagOfWords(String propertyFile) throws IOException {
        this.exportBagOfWords(propertyFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportBagOfWords(String propertyFile, BagOfWordsDecorator bDecorator) throws IOException {
        Properties props = new Properties();
        this.loadProperties(propertyFile, props);
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new FileWriter(props.getProperty("arffFile")));
            this.exportBagOfWords(props.getProperty("arffRelation"), props.getProperty("instanceClassQuery"), props.getProperty("numericWordQuery", ""), props.getProperty("nominalWordQuery", ""), writer, bDecorator);
        }
    }

    protected Instances initializeInstances(String arffRelation, BagOfWordsData bagOfWordsData, BagOfWordsDecorator bDecorator) {
        FastVector wekaAttributes = new FastVector(bagOfWordsData.getNumericWords().size() + bagOfWordsData.getNominalWordValueMap().size() + 2);
        wekaAttributes.addElement((Object)new Attribute(INSTANCE_ID));
        for (String string : bagOfWordsData.getNumericWords()) {
            Attribute attribute = new Attribute(string);
            wekaAttributes.addElement((Object)attribute);
        }
        for (Map.Entry entry : bagOfWordsData.getNominalWordValueMap().entrySet()) {
            FastVector wordValues = new FastVector(((SortedSet)entry.getValue()).size());
            for (String wordValue : (SortedSet)entry.getValue()) {
                wordValues.addElement((Object)wordValue);
            }
            Attribute attribute = new Attribute((String)entry.getKey(), wordValues);
            wekaAttributes.addElement((Object)attribute);
        }
        FastVector wekaClassLabels = new FastVector(bagOfWordsData.getClasses().size());
        for (String classLabel : bagOfWordsData.getClasses()) {
            wekaClassLabels.addElement((Object)classLabel);
        }
        wekaAttributes.addElement((Object)new Attribute(CLASS, wekaClassLabels));
        Instances instances = new Instances(arffRelation, wekaAttributes, 0);
        instances.setClassIndex(instances.numAttributes() - 1);
        return instances;
    }

    protected void getInstances(final String sql, final BagOfWordsData bagOfWordsData) {
        this.txNew.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus txStatus) {
                WekaBagOfWordsExporterImpl.this.jdbcTemplate.query(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                        return conn.prepareStatement(sql, 1003, 1007);
                    }
                }, new RowCallbackHandler(){
                    private Set<String> numericColumnHeaders;
                    private Set<String> nominalColumnHeaders;

                    private void initMetaData(ResultSet rs) throws SQLException {
                        if (this.numericColumnHeaders == null) {
                            this.numericColumnHeaders = new HashSet<String>();
                            this.nominalColumnHeaders = new HashSet<String>();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            for (int i = 3; i <= rsmd.getColumnCount(); ++i) {
                                int colType = rsmd.getColumnType(i);
                                if (colType == 1 || colType == 16 || colType == 12) {
                                    this.nominalColumnHeaders.add(rsmd.getColumnLabel(i));
                                    continue;
                                }
                                if (colType != 3 && colType != -5 && colType != 8 && colType != 6 && colType != 3 && colType != 4 && colType != 2 && colType != 7) continue;
                                this.numericColumnHeaders.add(rsmd.getColumnLabel(i));
                            }
                        }
                    }

                    public void processRow(ResultSet rs) throws SQLException {
                        this.initMetaData(rs);
                        int instanceId = rs.getInt(1);
                        String classLabel = rs.getString(2);
                        bagOfWordsData.getDocumentClasses().put(instanceId, classLabel);
                        bagOfWordsData.getClasses().add(classLabel);
                        for (String columnHeader : this.numericColumnHeaders) {
                            double wordValue = rs.getDouble(columnHeader);
                            if (rs.wasNull()) continue;
                            WekaBagOfWordsExporterImpl.this.addNumericWordToInstance(bagOfWordsData, instanceId, columnHeader, wordValue);
                        }
                        for (String columnHeader : this.nominalColumnHeaders) {
                            String wordValue = rs.getString(columnHeader);
                            if (rs.wasNull()) continue;
                            WekaBagOfWordsExporterImpl.this.addNominalWordToInstance(bagOfWordsData, instanceId, columnHeader, wordValue);
                        }
                    }
                });
                return null;
            }
        });
    }
}

