/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.wsd;

import com.google.common.collect.TreeMultimap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.ctakes.ytex.kernel.metric.ConceptPairSimilarity;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.model.ConcRel;
import org.apache.ctakes.ytex.kernel.wsd.WordSenseDisambiguator;

public class WordSenseDisambiguatorImpl
implements WordSenseDisambiguator {
    ConceptSimilarityService conceptSimilarityService;

    public ConceptSimilarityService getConceptSimilarityService() {
        return this.conceptSimilarityService;
    }

    public void setConceptSimilarityService(ConceptSimilarityService conceptSimilarityService) {
        this.conceptSimilarityService = conceptSimilarityService;
    }

    @Override
    public String disambiguate(List<Set<String>> sentenceConcepts, int index, Set<String> contextConcepts, int windowSize, ConceptSimilarityService.SimilarityMetricEnum metric, Map<String, Double> scoreMap) {
        return this.disambiguate(sentenceConcepts, index, contextConcepts, windowSize, metric, scoreMap, true);
    }

    @Override
    public String disambiguate(List<Set<String>> sentenceConcepts, int index, Set<String> contextConcepts, int windowSize, ConceptSimilarityService.SimilarityMetricEnum metric, Map<String, Double> scoreMap, boolean weighted) {
        Set<String> candidateConcepts = sentenceConcepts.get(index);
        if (candidateConcepts.size() == 1) {
            return candidateConcepts.iterator().next();
        }
        HashMap<String, Integer> windowContextConcepts = new HashMap<String, Integer>();
        if (contextConcepts != null) {
            this.addConcepts(windowContextConcepts, contextConcepts);
        }
        int indexLeftStart = index - windowSize - 1;
        int indexRightStart = index + windowSize + 1;
        if (indexLeftStart < 0) {
            indexRightStart += -1 * indexLeftStart;
            indexLeftStart = 0;
        } else if (indexRightStart >= sentenceConcepts.size()) {
            indexLeftStart -= indexRightStart - sentenceConcepts.size() - 1;
            indexRightStart = sentenceConcepts.size() - 1;
        }
        if (indexLeftStart < 0) {
            indexLeftStart = 0;
        }
        if (indexRightStart >= sentenceConcepts.size()) {
            indexRightStart = sentenceConcepts.size() - 1;
        }
        if (indexLeftStart < index) {
            for (Set<String> cs : sentenceConcepts.subList(indexLeftStart, index)) {
                this.addConcepts(windowContextConcepts, cs);
            }
        }
        if (indexRightStart > index) {
            for (Set<String> cs : sentenceConcepts.subList(index + 1, indexRightStart + 1)) {
                this.addConcepts(windowContextConcepts, cs);
            }
        }
        TreeMultimap scoreConceptMap = TreeMultimap.create();
        for (String string : candidateConcepts) {
            scoreConceptMap.put((Object)this.scoreConcept(string, windowContextConcepts, metric, weighted), (Object)string);
        }
        boolean bNonZero = false;
        if (scoreMap != null) {
            for (Map.Entry scoreConcept : scoreConceptMap.entries()) {
                scoreMap.put((String)scoreConcept.getValue(), (Double)scoreConcept.getKey());
            }
        }
        SortedSet sortedSet = scoreConceptMap.get(scoreConceptMap.keySet().last());
        String bestConcept = null;
        if (sortedSet.size() == 1) {
            bestConcept = (String)sortedSet.iterator().next();
        } else if (sortedSet.size() == candidateConcepts.size()) {
            bestConcept = null;
        } else {
            double ic = 1000000.0;
            Map<String, ConcRel> conceptMap = this.getConceptSimilarityService().getConceptGraph().getConceptMap();
            for (String c : sortedSet) {
                ConcRel cr = conceptMap.get(c);
                if (cr == null || !(cr.getIntrinsicInfoContent() < ic)) continue;
                ic = cr.getIntrinsicInfoContent();
                bestConcept = c;
            }
        }
        return bestConcept;
    }

    private void addConcepts(Map<String, Integer> windowContextConcepts, Set<String> contextConcepts) {
        for (String c : contextConcepts) {
            Integer cn = windowContextConcepts.get(c);
            if (cn != null) {
                windowContextConcepts.put(c, cn + 1);
                continue;
            }
            windowContextConcepts.put(c, 1);
        }
    }

    private double scoreConcept(String concept, Map<String, Integer> windowContextConcepts, ConceptSimilarityService.SimilarityMetricEnum metric, boolean weighted) {
        List<ConceptSimilarityService.SimilarityMetricEnum> metrics = Arrays.asList(metric);
        double score = 0.0;
        for (Map.Entry<String, Integer> windowConcept : windowContextConcepts.entrySet()) {
            ConceptPairSimilarity csim = this.conceptSimilarityService.similarity(metrics, concept, windowConcept.getKey(), null, false);
            if (weighted) {
                score += csim.getSimilarities().get(0) * windowConcept.getValue().doubleValue();
                continue;
            }
            score += csim.getSimilarities().get(0).doubleValue();
        }
        return score;
    }
}

