/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.metric.BaseSimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;

public class LinMetric
extends BaseSimilarityMetric {
    private static final Log log = LogFactory.getLog(LinMetric.class);
    private boolean intrinsicIC = true;
    private boolean validCG = false;
    private String rootConcept = this.simSvc.getConceptGraph().getRoot();

    public boolean isIntrinsicIC() {
        return this.intrinsicIC;
    }

    public void setIntrinsicIC(boolean intrinsicIC) {
        this.intrinsicIC = intrinsicIC;
    }

    @Override
    public double similarity(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo) {
        if (!this.validCG) {
            return 0.0;
        }
        double lcsIC = this.initLcsIC(concept1, concept2, conceptFilter, simInfo, this.intrinsicIC);
        if (lcsIC == 0.0) {
            return 0.0;
        }
        double ic1 = this.simSvc.getIC(concept1, this.intrinsicIC);
        double ic2 = this.simSvc.getIC(concept2, this.intrinsicIC);
        if (!this.intrinsicIC && ic1 == 0.0 && !this.rootConcept.equals(concept1)) {
            return 0.0;
        }
        if (!this.intrinsicIC && ic2 == 0.0 && !this.rootConcept.equals(concept2)) {
            return 0.0;
        }
        double denom = ic1 + ic2;
        if (denom == 0.0) {
            return 0.0;
        }
        return 2.0 * lcsIC / denom;
    }

    public LinMetric(ConceptSimilarityService simSvc, boolean intrinsicIC) {
        super(simSvc);
        this.intrinsicIC = intrinsicIC;
        boolean bl = this.validCG = simSvc.getConceptGraph() != null;
        if (!this.intrinsicIC && this.validCG) {
            this.rootConcept = simSvc.getConceptGraph().getRoot();
        }
    }
}

