/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.metric.BaseSimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;

public class IntrinsicLCHMetric
extends BaseSimilarityMetric {
    double logMaxIC2 = 0.0;

    public IntrinsicLCHMetric(ConceptSimilarityService simSvc, Double maxIC) {
        super(simSvc);
        if (maxIC != null) {
            this.logMaxIC2 = Math.log(2.0 * maxIC) + 1.0;
        }
    }

    @Override
    public double similarity(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo) {
        double sim = 0.0;
        if (this.logMaxIC2 != 0.0) {
            double ic1 = this.simSvc.getIC(concept1, true);
            double ic2 = this.simSvc.getIC(concept2, true);
            double lcsIC = this.initLcsIC(concept1, concept2, conceptFilter, simInfo, true);
            sim = 1.0 - Math.log(ic1 + ic2 - 2.0 * lcsIC + 1.0) / this.logMaxIC2;
        }
        return sim;
    }
}

