/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.salience;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class SemanticEnvironmentFeatureExtractor
implements FeatureExtractor1<Markable> {
    private static Set<String> propVerbs = Sets.newHashSet((Object[])new String[]{"allow", "believe", "bother", "demand", "deny", "doubt", "expect", "feel", "forbid", "guess", "hate", "hear", "hope", "imagine", "need", "promise", "realize", "remember", "said", "say", "see", "suppose", "tell", "think", "understand", "want", "worry"});

    public List<Feature> extract(JCas jcas, Markable markable) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ConllDependencyNode head = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)markable);
        if (head == null) {
            return feats;
        }
        Sentence sent = DependencyUtility.getSentence((JCas)jcas, (Annotation)markable);
        List sentNodes = DependencyUtility.getDependencyNodes((JCas)jcas, (Annotation)sent);
        List covering = DependencyUtility.getProgeny((ConllDependencyNode)head, (List)sentNodes);
        List events = JCasUtil.selectCovered((JCas)jcas, EventMention.class, (AnnotationFS)markable);
        EventMention markableEvent = null;
        for (EventMention event : events) {
            ConllDependencyNode eventHead = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)event);
            if (eventHead != head || markableEvent != null && event.getEnd() - event.getBegin() <= markableEvent.getEnd() - markableEvent.getBegin()) continue;
            markableEvent = event;
        }
        boolean neg = false;
        if (markableEvent != null) {
            neg = markableEvent.getPolarity() == -1;
            feats.add(new Feature("SemEnvNegation", (Object)neg));
        }
        boolean modal = SemanticEnvironmentFeatureExtractor.presenceOfModality(head, sentNodes);
        feats.add(new Feature("SemEnvModality", (Object)modal));
        boolean underPropVerb = SemanticEnvironmentFeatureExtractor.presenceOfAttitude(jcas, head);
        feats.add(new Feature("SemEnvAttitude", (Object)underPropVerb));
        if (head.getPostag().startsWith("PRP") || head.getPostag().equals("DT") && !head.getDeprel().equals("det")) {
            feats.add(new Feature("SemEnvProTrueModal" + modal, (Object)true));
            feats.add(new Feature("SemEnvProTrueNeg" + neg, (Object)true));
            feats.add(new Feature("SemEnvProTrueAtt" + underPropVerb, (Object)true));
        } else {
            feats.add(new Feature("SemEnvProFalseModal" + modal, (Object)true));
            feats.add(new Feature("SemEnvProFalseNeg" + neg, (Object)true));
            feats.add(new Feature("SemEnvProFalseAtt" + underPropVerb, (Object)true));
        }
        if (head.getPostag().equals("NNP")) {
            feats.add(new Feature("SemEnvProperTrueModal" + modal, (Object)true));
            feats.add(new Feature("SemEnvProperTrueNeg" + neg, (Object)true));
            feats.add(new Feature("SemEnvProperTrueAtt" + underPropVerb, (Object)true));
        } else {
            feats.add(new Feature("SemEnvProperFalseModal" + modal, (Object)true));
            feats.add(new Feature("SemEnvProperFalseNeg" + neg, (Object)true));
            feats.add(new Feature("SemEnvProperFalseAtt" + underPropVerb, (Object)true));
        }
        boolean indefinite = false;
        for (ConllDependencyNode node : covering) {
            if (node.getId() == 0 || !node.getPostag().equals("DT") || !node.getLemma().equals("a") && !node.getLemma().equals("an")) continue;
            indefinite = true;
        }
        feats.add(new Feature("Neg" + neg + "Indef" + indefinite, (Object)true));
        feats.add(new Feature("Neg" + neg + "Mods" + (covering.size() - 1), (Object)true));
        return feats;
    }

    private static final boolean presenceOfModality(ConllDependencyNode head, List<ConllDependencyNode> sentNodes) {
        boolean modal = false;
        ConllDependencyNode vb = null;
        if (head.getHead() != null) {
            vb = head.getHead();
            while (vb.getHead() != null && !vb.getPostag().startsWith("VB")) {
                vb = vb.getHead();
            }
            for (ConllDependencyNode node : sentNodes) {
                if (node.getHead() != vb || !node.getPostag().equals("MD")) continue;
                modal = true;
                break;
            }
        }
        return modal;
    }

    private static final boolean presenceOfAttitude(JCas jcas, ConllDependencyNode head) {
        boolean att = false;
        for (ConllDependencyNode cur : DependencyUtility.getPathToTop((JCas)jcas, (ConllDependencyNode)head)) {
            if (!propVerbs.contains(cur.getLemma())) continue;
            att = true;
            break;
        }
        return att;
    }
}

