/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.util.ListIterable;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.coreference.ae.features.UMLSFeatureExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.utils.struct.MapFactory;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MentionClusterUMLSFeatureExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>,
FeatureExtractor1<Markable> {
    String docId = null;
    Map<ConllDependencyNode, Collection<IdentifiedAnnotation>> coveringMap = null;

    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ConllDependencyNode head;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        HashSet<String> trueFeats = new HashSet<String>();
        if (this.docId == null || !UMLSFeatureExtractor.getDocId(jCas).equals(this.docId)) {
            this.docId = UMLSFeatureExtractor.getDocId(jCas);
            this.coveringMap = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        }
        if ((head = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)mention)) != null) {
            ArrayList<IdentifiedAnnotation> rmList = new ArrayList<IdentifiedAnnotation>();
            ArrayList<IdentifiedAnnotation> mentionEnts = new ArrayList<IdentifiedAnnotation>(this.coveringMap.get(head));
            for (IdentifiedAnnotation ann : mentionEnts) {
                if ((ann instanceof EntityMention || ann instanceof EventMention) && ann.getClass() != EventMention.class) continue;
                rmList.add(ann);
            }
            for (IdentifiedAnnotation toRm : rmList) {
                mentionEnts.remove(toRm);
            }
            HashSet<IdentifiedAnnotation> clusterEnts = new HashSet<IdentifiedAnnotation>();
            for (Markable member : new ListIterable(cluster.getMembers())) {
                ConllDependencyNode memberHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)member);
                rmList.clear();
                ArrayList<IdentifiedAnnotation> ents2 = new ArrayList<IdentifiedAnnotation>(this.coveringMap.get(memberHead));
                for (IdentifiedAnnotation ann : ents2) {
                    if ((ann instanceof EntityMention || ann instanceof EventMention) && ann.getClass() != EventMention.class) continue;
                    rmList.add(ann);
                }
                for (IdentifiedAnnotation toRm : rmList) {
                    ents2.remove(toRm);
                }
                clusterEnts.addAll(ents2);
            }
            if (clusterEnts.size() == 0 && mentionEnts.size() > 0) {
                trueFeats.add("ClusterNoCui_MentionCui");
            } else if (clusterEnts.size() > 0 && mentionEnts.size() == 0) {
                trueFeats.add("ClusterCui_MentionNoCui");
            } else if (clusterEnts.size() == 0 && mentionEnts.size() == 0) {
                trueFeats.add("ClusterMentionNoCui");
            } else {
                trueFeats.add("ClusterMentionBothCui");
            }
            if (clusterEnts.size() == 0 & mentionEnts.size() > 0 || clusterEnts.size() > 0 && mentionEnts.size() == 0) {
                trueFeats.add("ClusterOrMentionNoCui");
            }
            for (IdentifiedAnnotation ent1 : clusterEnts) {
                HashSet<String> a1Tuis = new HashSet<String>();
                String a1SemType = ent1.getClass().getSimpleName();
                trueFeats.add("ClusterSemType" + a1SemType);
                FSArray cons1 = ent1.getOntologyConceptArr();
                if (cons1 != null) {
                    for (int i = 0; i < cons1.size(); ++i) {
                        UmlsConcept concept;
                        if (!(cons1.get(i) instanceof UmlsConcept) || (concept = (UmlsConcept)cons1.get(i)).getTui() == null) continue;
                        a1Tuis.add(concept.getTui());
                    }
                }
                for (IdentifiedAnnotation ent2 : mentionEnts) {
                    HashSet<String> a2Tuis = new HashSet<String>();
                    String a2SemType = ent2.getClass().getSimpleName();
                    if (UMLSFeatureExtractor.alias(ent1, ent2)) {
                        trueFeats.add("UMLS_ALIAS");
                    }
                    trueFeats.add("MentionClusterSemTypePair" + a1SemType + "_" + a2SemType);
                    FSArray cons2 = ent2.getOntologyConceptArr();
                    if (cons2 != null) {
                        for (int i = 0; i < cons2.size(); ++i) {
                            UmlsConcept concept;
                            if (!(cons2.get(i) instanceof UmlsConcept) || (concept = (UmlsConcept)cons2.get(i)).getTui() == null) continue;
                            a2Tuis.add(concept.getTui());
                        }
                    }
                    for (String tui1 : a1Tuis) {
                        for (String tui2 : a2Tuis) {
                            if (!tui1.equals(tui2)) continue;
                            trueFeats.add("ClusterMentionTuiMatch");
                        }
                    }
                }
            }
        }
        for (String feat : trueFeats) {
            feats.add(new Feature(feat, (Object)true));
        }
        return feats;
    }

    public List<Feature> extract(JCas jCas, Markable mention) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        HashSet<String> trueFeats = new HashSet<String>();
        if (this.docId == null || !UMLSFeatureExtractor.getDocId(jCas).equals(this.docId)) {
            this.docId = UMLSFeatureExtractor.getDocId(jCas);
            this.coveringMap = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        }
        ConllDependencyNode head = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)mention);
        ArrayList<IdentifiedAnnotation> rmList = new ArrayList<IdentifiedAnnotation>();
        ArrayList<IdentifiedAnnotation> mentionEnts = new ArrayList<IdentifiedAnnotation>(this.coveringMap.get(head));
        for (IdentifiedAnnotation ann : mentionEnts) {
            if ((ann instanceof EntityMention || ann instanceof EventMention) && ann.getClass() != EventMention.class) continue;
            rmList.add(ann);
        }
        for (IdentifiedAnnotation toRm : rmList) {
            mentionEnts.remove(toRm);
        }
        for (IdentifiedAnnotation ent : mentionEnts) {
            String a2SemType = ent.getClass().getSimpleName();
            trueFeats.add("MentionSemType" + a2SemType);
        }
        for (String feat : trueFeats) {
            feats.add(new Feature(feat, (Object)true));
        }
        return feats;
    }
}

