/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class SectionFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jcas, IdentifiedAnnotation ante, IdentifiedAnnotation ana) throws AnalysisEngineProcessException {
        Paragraph par;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        boolean anteInHeader = false;
        boolean anaInHeader = false;
        int antePar = -1;
        int anaPar = -1;
        ArrayList pars = new ArrayList(JCasUtil.select((JCas)jcas, Paragraph.class));
        for (int i = 0; i < pars.size() && (par = (Paragraph)pars.get(i)).getBegin() <= ana.getEnd(); ++i) {
            List coveredSents;
            if (ante.getBegin() >= par.getBegin() && ante.getEnd() <= par.getEnd()) {
                antePar = i;
            }
            if (ana.getBegin() >= par.getBegin() && ana.getEnd() <= par.getEnd()) {
                anaPar = i;
            }
            if ((coveredSents = JCasUtil.selectCovered((JCas)jcas, Sentence.class, (AnnotationFS)par)) == null || coveredSents.size() != 1) continue;
            if (antePar == i) {
                anteInHeader = true;
            }
            if (anaPar != i) continue;
            anaInHeader = true;
        }
        feats.add(new Feature("AnteInHeader", (Object)anteInHeader));
        feats.add(new Feature("AnaInHeader", (Object)anaInHeader));
        if (anteInHeader && antePar + 1 == anaPar) {
            feats.add(new Feature("AnteHeaderHeadsAna", (Object)true));
        }
        return feats;
    }
}

