/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.CliOptionals;
import org.apache.ctakes.core.pipeline.CliOptionalsHandler;
import org.apache.ctakes.core.pipeline.PipelineBuilder;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.resource.ResourceInitializationException;

public final class PiperFileReader {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperFileReader");
    private static final String[] CTAKES_PACKAGES = new String[]{"core", "assertion", "chunker", "clinicalpipeline", "constituency.parser", "contexttokenizer", "coreference", "dependency.parser", "dictionary.lookup2", "dictionary.lookup", "temporal", "drug-ner", "lvg", "necontexts", "postagger", "prepropessor", "relationextractor", "sideeffect", "smokingstatus", "template.filler"};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("=");
    private static final Pattern COMMA_ARRAY_PATTERN = Pattern.compile(",");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private static final Pattern QUOTE_VALUE_PATTERN = Pattern.compile("(?:[^\"=\\s]+)|(?:\"[^\"=\\r\\n]+\")");
    private static final Pattern NAME_VALUE_PATTERN = Pattern.compile("[^\"\\s=]+=(?:(?:[^\"=\\s]+)|(?:\"[^\"=\\r\\n]+\"))");
    private PipelineBuilder _builder = new PipelineBuilder();
    private final Collection<String> _userPackages = new ArrayList<String>();
    private CliOptionals _cliOptionals;

    public PiperFileReader() {
    }

    public PiperFileReader(String filePath) throws UIMAException {
        this.loadPipelineFile(filePath);
    }

    public PiperFileReader(String filePath, CliOptionals cliOptionals) throws UIMAException {
        this.setCliOptionals(cliOptionals);
        this.loadPipelineFile(filePath);
    }

    public void setCliOptionals(CliOptionals cliOptionals) {
        this._cliOptionals = cliOptionals;
    }

    public boolean loadPipelineFile(String filePath) throws UIMAException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileLocator.getAsStream(this.getPiperPath(filePath))));){
            String line = reader.readLine();
            while (line != null) {
                this.parsePipelineLine(line.trim());
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Piper File not found: " + filePath));
            return false;
        }
        return true;
    }

    public boolean parsePipelineLine(String line) throws UIMAException {
        if (line.isEmpty() || line.startsWith("//") || line.startsWith("#") || line.startsWith("!")) {
            return true;
        }
        int spaceIndex = line.indexOf(32);
        if (spaceIndex < 0) {
            return this.addToPipeline(line, "");
        }
        return this.addToPipeline(line.substring(0, spaceIndex), line.substring(spaceIndex + 1).trim());
    }

    public PipelineBuilder getBuilder() {
        return this._builder;
    }

    private boolean addToPipeline(String command, String parameter) throws UIMAException {
        switch (command) {
            case "load": {
                return this.loadPipelineFile(parameter);
            }
            case "package": {
                this._userPackages.add(parameter);
                return true;
            }
            case "set": {
                this._builder.set(PiperFileReader.splitParameters(parameter));
                return true;
            }
            case "cli": {
                this._builder.set(this.getCliParameters(parameter));
                return true;
            }
            case "reader": {
                if (PiperFileReader.hasParameters(parameter)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(parameter);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.reader(this.getReaderClass(component), parameters);
                } else {
                    this._builder.reader(this.getReaderClass(parameter), new Object[0]);
                }
                return true;
            }
            case "readFiles": {
                if (parameter.isEmpty()) {
                    this._builder.readFiles();
                } else {
                    this._builder.readFiles(parameter);
                }
                return true;
            }
            case "add": {
                if (PiperFileReader.hasParameters(parameter)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(parameter);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.add(this.getComponentClass(component), parameters);
                } else {
                    this._builder.add(this.getComponentClass(parameter), new Object[0]);
                }
                return true;
            }
            case "addLogged": {
                if (PiperFileReader.hasParameters(parameter)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(parameter);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.addLogged(this.getComponentClass(component), parameters);
                } else {
                    this._builder.addLogged(this.getComponentClass(parameter), new Object[0]);
                }
                return true;
            }
            case "addDescription": {
                if (PiperFileReader.hasParameters(parameter)) {
                    String[] descriptor_parameters = PiperFileReader.splitFromParameters(parameter);
                    String component = descriptor_parameters[0];
                    Object[] values = PiperFileReader.splitDescriptorValues(descriptor_parameters[1]);
                    AnalysisEngineDescription description = this.createDescription(component, values);
                    this._builder.addDescription(description);
                } else {
                    AnalysisEngineDescription description = this.createDescription(parameter, new Object[0]);
                    this._builder.addDescription(description);
                }
                return true;
            }
            case "addLast": {
                if (PiperFileReader.hasParameters(parameter)) {
                    String[] component_parameters = PiperFileReader.splitFromParameters(parameter);
                    String component = component_parameters[0];
                    Object[] parameters = PiperFileReader.splitParameters(component_parameters[1]);
                    this._builder.addLast(this.getComponentClass(component), parameters);
                } else {
                    this._builder.addLast(this.getComponentClass(parameter), new Object[0]);
                }
                return true;
            }
            case "collectCuis": {
                this._builder.collectCuis();
                return true;
            }
            case "collectEntities": {
                this._builder.collectEntities();
                return true;
            }
            case "writeXmis": {
                if (parameter.isEmpty()) {
                    this._builder.writeXMIs();
                } else {
                    this._builder.writeXMIs(parameter);
                }
                return true;
            }
        }
        LOGGER.error((Object)("Unknown Piper Command: " + command));
        return false;
    }

    private Class<? extends AnalysisComponent> getComponentClass(String className) throws ResourceInitializationException {
        Class<Object> componentClass;
        try {
            componentClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfE) {
            componentClass = this.getPackagedComponent(className);
        }
        if (componentClass == null) {
            throw new ResourceInitializationException("No Analysis Component found for " + className, EMPTY_OBJECT_ARRAY);
        }
        PiperFileReader.assertClassType(componentClass, AnalysisComponent.class);
        return componentClass;
    }

    private Class<? extends AnalysisComponent> getPackagedComponent(String className) {
        Class<?> componentClass;
        for (String packageName : this._userPackages) {
            componentClass = PiperFileReader.getPackagedClass(packageName, className, AnalysisComponent.class);
            if (componentClass == null) continue;
            return componentClass;
        }
        for (String packageName : CTAKES_PACKAGES) {
            componentClass = PiperFileReader.getPackagedClass("org.apache.ctakes." + packageName + ".ae", className, AnalysisComponent.class);
            if (componentClass != null) {
                return componentClass;
            }
            componentClass = PiperFileReader.getPackagedClass("org.apache.ctakes." + packageName + ".cc", className, AnalysisComponent.class);
            if (componentClass != null) {
                return componentClass;
            }
            componentClass = PiperFileReader.getPackagedClass("org.apache.ctakes." + packageName, className, AnalysisComponent.class);
            if (componentClass == null) continue;
            return componentClass;
        }
        return null;
    }

    private String getPiperPath(String filePath) throws FileNotFoundException {
        String fullPath = FileLocator.getFullPathQuiet(filePath);
        if (fullPath != null && !fullPath.isEmpty()) {
            return fullPath;
        }
        for (String packageName : this._userPackages) {
            fullPath = FileLocator.getFullPathQuiet(packageName.replace('.', '/') + '/' + filePath);
            if (fullPath != null && !fullPath.isEmpty()) {
                return fullPath;
            }
            fullPath = FileLocator.getFullPathQuiet(packageName.replace('.', '/') + "/pipeline/" + filePath);
            if (fullPath == null || fullPath.isEmpty()) continue;
            return fullPath;
        }
        for (String packageName : CTAKES_PACKAGES) {
            fullPath = FileLocator.getFullPathQuiet("org/apache/ctakes/" + packageName.replace('.', '/') + '/' + filePath);
            if (fullPath != null && !fullPath.isEmpty()) {
                return fullPath;
            }
            fullPath = FileLocator.getFullPathQuiet("org/apache/ctakes/" + packageName.replace('.', '/') + "/pipeline/" + filePath);
            if (fullPath == null || fullPath.isEmpty()) continue;
            return fullPath;
        }
        throw new FileNotFoundException("No piper file found for " + filePath);
    }

    private AnalysisEngineDescription createDescription(String className, Object ... values) throws ResourceInitializationException {
        Method method;
        Class<? extends AnalysisComponent> componentClass = this.getComponentClass(className);
        try {
            method = values.length == 0 ? componentClass.getMethod("createAnnotatorDescription", new Class[0]) : componentClass.getMethod("createAnnotatorDescription", PiperFileReader.getValueTypes(values));
        }
        catch (NoSuchMethodException nsmE) {
            LOGGER.error((Object)("No createAnnotatorDescription method in " + className));
            throw new ResourceInitializationException((Throwable)nsmE);
        }
        try {
            Object invocation = method.invoke(null, values);
            if (!AnalysisEngineDescription.class.isInstance(invocation)) {
                LOGGER.error((Object)("createAnnotatorDescription in " + className + " returned an " + invocation.getClass().getName() + " not an AnalysisEngineDescription"));
                throw new ResourceInitializationException();
            }
            return (AnalysisEngineDescription)invocation;
        }
        catch (IllegalAccessException | InvocationTargetException multE) {
            LOGGER.error((Object)("Could not invoke createAnnotatorDescription on " + className));
            throw new ResourceInitializationException((Throwable)multE);
        }
    }

    private static Class<?>[] getValueTypes(Object ... values) {
        Class[] classArray = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            Class<?> type = values[i].getClass();
            classArray[i] = type.equals(Integer.class) ? Integer.TYPE : (type.equals(Boolean.class) ? Boolean.TYPE : type);
        }
        return classArray;
    }

    private Class<? extends CollectionReader> getReaderClass(String className) throws ResourceInitializationException {
        Class<Object> readerClass;
        try {
            readerClass = Class.forName(className);
        }
        catch (ClassNotFoundException cnfE) {
            readerClass = this.getPackagedReader(className);
        }
        if (readerClass == null) {
            throw new ResourceInitializationException("No Collection Reader found for " + className, EMPTY_OBJECT_ARRAY);
        }
        PiperFileReader.assertClassType(readerClass, CollectionReader.class);
        return readerClass;
    }

    private Class<? extends CollectionReader> getPackagedReader(String className) {
        Class<?> readerClass;
        for (String packageName : this._userPackages) {
            readerClass = PiperFileReader.getPackagedClass(packageName, className, CollectionReader.class);
            if (readerClass == null) continue;
            return readerClass;
        }
        for (String packageName : CTAKES_PACKAGES) {
            readerClass = PiperFileReader.getPackagedClass("org.apache.ctakes." + packageName + ".cr", className, CollectionReader.class);
            if (readerClass != null) {
                return readerClass;
            }
            readerClass = PiperFileReader.getPackagedClass("org.apache.ctakes." + packageName, className, CollectionReader.class);
            if (readerClass == null) continue;
            return readerClass;
        }
        return null;
    }

    private static Class<?> getPackagedClass(String packageName, String className, Class<?> wantedClassType) {
        try {
            Class<?> classType = Class.forName(packageName + "." + className);
            if (PiperFileReader.isClassType(classType, wantedClassType)) {
                return classType;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private static void assertClassType(Class<?> classType, Class<?> wantedClassType) throws ResourceInitializationException {
        if (!PiperFileReader.isClassType(classType, wantedClassType)) {
            throw new ResourceInitializationException("Not " + wantedClassType.getSimpleName() + " " + classType.getName(), EMPTY_OBJECT_ARRAY);
        }
    }

    private static boolean isClassType(Class<?> classType, Class<?> wantedClassType) {
        return wantedClassType.isAssignableFrom(classType);
    }

    private static boolean hasParameters(String text) {
        return SPACE_PATTERN.split(text).length > 1;
    }

    private static String[] splitFromParameters(String text) {
        String[] allSplits = SPACE_PATTERN.split(text);
        String[] returnSplits = new String[2];
        returnSplits[0] = allSplits[0];
        String parameters = allSplits[1];
        for (int i = 2; i < allSplits.length; ++i) {
            parameters = parameters + " " + allSplits[i];
        }
        returnSplits[1] = parameters;
        return returnSplits;
    }

    private static Object[] splitParameters(String text) {
        if (text == null || text.trim().isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        }
        Matcher matcher = NAME_VALUE_PATTERN.matcher(text);
        ArrayList<String> pairList = new ArrayList<String>();
        while (matcher.find()) {
            pairList.add(text.substring(matcher.start(), matcher.end()));
        }
        String[] pairs = pairList.toArray(new String[pairList.size()]);
        Object[] keysAndValues = new Object[pairs.length * 2];
        int i = 0;
        for (String pair : pairs) {
            String[] keyAndValue = KEY_VALUE_PATTERN.split(pair);
            keysAndValues[i] = keyAndValue[0];
            if (keyAndValue.length == 1) {
                keysAndValues[i + 1] = "";
                i += 2;
                continue;
            }
            if (keyAndValue.length > 2) {
                LOGGER.warn((Object)("Multiple parameter values, using first of " + pair));
            }
            keysAndValues[i + 1] = PiperFileReader.getValueObject(keyAndValue[1]);
            i += 2;
        }
        return keysAndValues;
    }

    private Object[] getCliParameters(String text) {
        if (this._cliOptionals == null) {
            LOGGER.warn((Object)"Attempted to set Parameter by Command-line options.  Command-line options are not specified.");
            return EMPTY_OBJECT_ARRAY;
        }
        if (text == null || text.trim().isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        }
        Matcher matcher = NAME_VALUE_PATTERN.matcher(text);
        ArrayList<String> pairList = new ArrayList<String>();
        while (matcher.find()) {
            pairList.add(text.substring(matcher.start(), matcher.end()));
        }
        String[] pairs = pairList.toArray(new String[pairList.size()]);
        Object[] keysAndValues = new Object[pairs.length * 2];
        int i = 0;
        for (String pair : pairs) {
            String[] keyAndValue = KEY_VALUE_PATTERN.split(pair);
            keysAndValues[i] = keyAndValue[0];
            if (keyAndValue.length == 1) {
                keysAndValues[i + 1] = "";
                i += 2;
                continue;
            }
            if (keyAndValue.length > 2) {
                LOGGER.warn((Object)("Multiple parameter values, using first of " + pair));
            }
            keysAndValues[i + 1] = PiperFileReader.getValueObject(CliOptionalsHandler.getCliOptionalValue(this._cliOptionals, keyAndValue[1]));
            i += 2;
        }
        return keysAndValues;
    }

    private static Object[] splitDescriptorValues(String text) {
        Matcher matcher = QUOTE_VALUE_PATTERN.matcher(text);
        ArrayList<String> valueList = new ArrayList<String>();
        while (matcher.find()) {
            valueList.add(text.substring(matcher.start(), matcher.end()));
        }
        String[] values = valueList.toArray(new String[valueList.size()]);
        Object[] valueObjects = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            valueObjects[i] = PiperFileReader.getValueObject(values[i]);
        }
        return valueObjects;
    }

    private static Object getValueObject(String value) {
        if (value.indexOf(34) >= 0) {
            return QUOTE_PATTERN.matcher(value).replaceAll("");
        }
        if (PiperFileReader.isCommaArray(value)) {
            return PiperFileReader.attemptParseArray(value);
        }
        Object returner = PiperFileReader.attemptParseBoolean(value);
        if (!value.equals(returner)) {
            return returner;
        }
        return PiperFileReader.attemptParseInt(value);
    }

    private static Object attemptParseInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException nfE) {
            return value;
        }
    }

    private static Object attemptParseBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return value;
    }

    private static boolean isCommaArray(String value) {
        return value.indexOf(44) > 0;
    }

    private static Object attemptParseArray(String value) {
        return COMMA_ARRAY_PATTERN.split(value);
    }
}

