/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.CombineCondition;
import org.apache.ctakes.core.fsm.condition.IntegerRangeCondition;
import org.apache.ctakes.core.fsm.condition.NegateCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.output.DateToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.state.NonTerminalEndState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class DateFSM {
    private final int MIN_MONTH = 1;
    private final int MAX_MONTH = 12;
    private final int MIN_DAY = 1;
    private final int MAX_DAY = 31;
    private final int MIN_YEAR = 1;
    private final int MAX_YEAR = 2999;
    private Set<String> iv_monthFullNameSet = new HashSet<String>();
    private Set<String> iv_monthShortNameSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public DateFSM() {
        this.iv_monthFullNameSet.add("january");
        this.iv_monthFullNameSet.add("february");
        this.iv_monthFullNameSet.add("march");
        this.iv_monthFullNameSet.add("april");
        this.iv_monthFullNameSet.add("may");
        this.iv_monthFullNameSet.add("june");
        this.iv_monthFullNameSet.add("july");
        this.iv_monthFullNameSet.add("august");
        this.iv_monthFullNameSet.add("september");
        this.iv_monthFullNameSet.add("october");
        this.iv_monthFullNameSet.add("november");
        this.iv_monthFullNameSet.add("december");
        this.iv_monthShortNameSet.add("jan");
        this.iv_monthShortNameSet.add("feb");
        this.iv_monthShortNameSet.add("mar");
        this.iv_monthShortNameSet.add("apr");
        this.iv_monthShortNameSet.add("may");
        this.iv_monthShortNameSet.add("jun");
        this.iv_monthShortNameSet.add("jul");
        this.iv_monthShortNameSet.add("aug");
        this.iv_monthShortNameSet.add("sep");
        this.iv_monthShortNameSet.add("sept");
        this.iv_monthShortNameSet.add("oct");
        this.iv_monthShortNameSet.add("nov");
        this.iv_monthShortNameSet.add("dec");
        this.iv_machineSet.add(this.getNumericDateMachine());
        this.iv_machineSet.add(this.getTextualDateMachine());
    }

    private Machine getNumericDateMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine machine = new Machine((State)startState);
        NamedState monthNumState = new NamedState("MONTH_NUM");
        NamedState monthDaySeparatorState = new NamedState("MONTH_DAY_SEP");
        NamedState dayNumState = new NamedState("DAY_NUM");
        NamedState dayYearSeparatorState = new NamedState("DAY_YEAR_SEP");
        IntegerRangeCondition monthNumCondition = new IntegerRangeCondition(1, 12);
        PunctuationValueCondition mdFslashCondition = new PunctuationValueCondition('/');
        PunctuationValueCondition mdDashCondition = new PunctuationValueCondition('-');
        PunctuationValueCondition dyFslashCondition = new PunctuationValueCondition('/');
        PunctuationValueCondition dyDashCondition = new PunctuationValueCondition('-');
        IntegerRangeCondition dayNumCondition = new IntegerRangeCondition(1, 31);
        IntegerRangeCondition yearNumCondition = new IntegerRangeCondition(1, 2999);
        CombineCondition notFslashNotDashCondition = new CombineCondition(new NegateCondition(mdFslashCondition), new NegateCondition(mdDashCondition));
        startState.addTransition(monthNumCondition, monthNumState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        monthNumState.addTransition(mdFslashCondition, monthDaySeparatorState);
        monthNumState.addTransition(mdDashCondition, monthDaySeparatorState);
        monthNumState.addTransition((Condition)new AnyCondition(), startState);
        monthDaySeparatorState.addTransition(dayNumCondition, dayNumState);
        monthDaySeparatorState.addTransition((Condition)new AnyCondition(), startState);
        dayNumState.addTransition(dyFslashCondition, dayYearSeparatorState);
        dayNumState.addTransition(dyDashCondition, dayYearSeparatorState);
        dayNumState.addTransition(notFslashNotDashCondition, ntEndState);
        dayNumState.addTransition((Condition)new AnyCondition(), startState);
        dayYearSeparatorState.addTransition(yearNumCondition, endState);
        dayYearSeparatorState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        ntEndState.addTransition((Condition)new AnyCondition(), startState);
        return machine;
    }

    private Machine getTextualDateMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        NonTerminalEndState ntEndState = new NonTerminalEndState("NON TERMINAL END");
        endState.setEndStateFlag(true);
        ntEndState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState monthFullTextState = new NamedState("MONTH_FULL_TEXT");
        NamedState monthShortTextState = new NamedState("MONTH_SHORT_TEXT");
        NamedState dayNumState = new NamedState("DAY_NUM");
        NamedState commaState = new NamedState("COMMA");
        NamedState periodState = new NamedState("PERIOD");
        WordSetCondition monthFullTextCondition = new WordSetCondition(this.iv_monthFullNameSet, false);
        WordSetCondition monthShortTextCondition = new WordSetCondition(this.iv_monthShortNameSet, false);
        IntegerRangeCondition dayNumCondition = new IntegerRangeCondition(1, 31);
        PunctuationValueCondition periodCondition = new PunctuationValueCondition('.');
        IntegerRangeCondition yearNumCondition = new IntegerRangeCondition(1, 2999);
        PunctuationValueCondition commaCondition = new PunctuationValueCondition(',');
        CombineCondition notCommaNotYearNumCondition = new CombineCondition(new NegateCondition(commaCondition), new NegateCondition(yearNumCondition));
        CombineCondition yearNotDayNumCondition = new CombineCondition(yearNumCondition, new NegateCondition(dayNumCondition));
        startState.addTransition(monthFullTextCondition, monthFullTextState);
        startState.addTransition(monthShortTextCondition, monthShortTextState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        monthFullTextState.addTransition(dayNumCondition, dayNumState);
        monthFullTextState.addTransition(yearNotDayNumCondition, endState);
        monthFullTextState.addTransition((Condition)new AnyCondition(), startState);
        monthShortTextState.addTransition(dayNumCondition, dayNumState);
        monthShortTextState.addTransition(periodCondition, periodState);
        monthShortTextState.addTransition(yearNotDayNumCondition, endState);
        monthShortTextState.addTransition((Condition)new AnyCondition(), startState);
        periodState.addTransition(dayNumCondition, dayNumState);
        periodState.addTransition(yearNotDayNumCondition, endState);
        periodState.addTransition((Condition)new AnyCondition(), startState);
        dayNumState.addTransition(yearNumCondition, endState);
        dayNumState.addTransition(commaCondition, commaState);
        dayNumState.addTransition(notCommaNotYearNumCondition, ntEndState);
        dayNumState.addTransition((Condition)new AnyCondition(), startState);
        commaState.addTransition(yearNumCondition, endState);
        commaState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        ntEndState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<DateToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<DateToken> dateSet = new HashSet<DateToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken endToken = null;
                endToken = currentState instanceof NonTerminalEndState ? tokens.get(i - 1) : token;
                BaseToken startToken = tokens.get(tokenStartIndex);
                DateToken dateToken = new DateToken(startToken.getStartOffset(), endToken.getEndOffset());
                dateSet.add(dateToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return dateSet;
    }
}

