/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.adapters;

import org.apache.ctakes.core.fsm.adapters.NumberTokenAdapter;
import org.apache.ctakes.core.fsm.token.IntegerToken;
import org.apache.ctakes.typesystem.type.syntax.NumToken;

public class IntegerTokenAdapter
extends NumberTokenAdapter
implements IntegerToken {
    private long iv_val;
    private double iv_double;
    static String negativeSign = "-";

    public IntegerTokenAdapter(NumToken nta) {
        block7: {
            super(nta);
            if (nta.getCoveredText().length() > 0) {
                String numAsString = this.removeCommas(nta.getCoveredText());
                try {
                    this.iv_val = Long.parseLong(numAsString);
                }
                catch (NumberFormatException e) {
                    this.iv_val = numAsString.startsWith(negativeSign) ? Long.MIN_VALUE : Long.MAX_VALUE;
                }
                try {
                    this.iv_double = Double.parseDouble(numAsString);
                }
                catch (NumberFormatException e) {
                    if (numAsString.startsWith(negativeSign)) {
                        this.iv_double = -1.7976931348623157E308;
                        break block7;
                    }
                    this.iv_double = Double.MAX_VALUE;
                }
            } else {
                this.iv_val = 0L;
                this.iv_double = 0.0;
            }
        }
    }

    @Override
    public long getValue() {
        return this.iv_val;
    }

    public double getValueAsDouble() {
        return this.iv_double;
    }
}

