/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.property.plaintext;

import org.apache.ctakes.core.cc.property.plaintext.PropertyTextWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Property Text Writer", description="Writes text files with lists of annotations and properties (POS, Semantic Group, CUI, Negation).", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class PropertyTextWriterFit
extends CasConsumer_ImplBase {
    @ConfigurationParameter(name="OutputDirectory", mandatory=false, description="Directory for all output files.", defaultValue={""})
    private String fitOutputDirectoryPath;
    private final PropertyTextWriter _propertyTextWriter = new PropertyTextWriter();

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            if (this.fitOutputDirectoryPath != null) {
                this._propertyTextWriter.setOutputDirectory(this.fitOutputDirectoryPath);
            } else {
                this._propertyTextWriter.setOutputDirectory((String)uimaContext.getConfigParameterValue("OutputDirectory"));
            }
        }
        catch (IllegalArgumentException | SecurityException multE) {
            throw new ResourceInitializationException((Throwable)multE);
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException casE) {
            throw new AnalysisEngineProcessException((Throwable)casE);
        }
        this._propertyTextWriter.process(jcas);
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return PropertyTextWriterFit.createAnnotatorDescription("");
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String outputDirectoryPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(PropertyTextWriterFit.class, (Object[])new Object[]{"OutputDirectory", outputDirectoryPath});
    }
}

