/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

@PipeBitInfo(name="Word Count Writer", description="Writes a two-column BSV file containing Words and their total counts in a document.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN})
public class TokenFreqCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_WORD_FREQ_FILE = "TokenFreqFile";
    File wordFreqFile;
    Map<String, int[]> wordFreqs;

    public void initialize() throws ResourceInitializationException {
        try {
            String wordFreqFileName = (String)this.getConfigParameterValue(PARAM_WORD_FREQ_FILE);
            this.wordFreqFile = new File(wordFreqFileName);
            if (!this.wordFreqFile.exists()) {
                this.wordFreqFile.createNewFile();
            }
        }
        catch (Exception ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
        this.wordFreqs = new HashMap<String, int[]>();
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            for (WordToken token : indexes.getAnnotationIndex(WordToken.type)) {
                String text = token.getCoveredText();
                if (!this.wordFreqs.containsKey(text)) {
                    this.wordFreqs.put(text, new int[1]);
                }
                int[] nArray = this.wordFreqs.get(text);
                nArray[0] = nArray[0] + 1;
            }
        }
        catch (Exception exception) {
            throw new ResourceProcessException((Throwable)exception);
        }
    }

    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        TreeSet<Object[]> sortedFreqs = new TreeSet<Object[]>(new Comparator<Object[]>(){

            @Override
            public int compare(Object[] tokenFreq1, Object[] tokenFreq2) {
                Integer freq2 = (Integer)tokenFreq2[1];
                Integer freq1 = (Integer)tokenFreq1[1];
                if (!freq2.equals(freq1)) {
                    return freq2.compareTo(freq1);
                }
                String token1 = (String)tokenFreq1[0];
                String token2 = (String)tokenFreq2[0];
                return token1.compareTo(token2);
            }
        });
        for (String word : this.wordFreqs.keySet()) {
            int freq = this.wordFreqs.get(word)[0];
            sortedFreqs.add(new Object[]{word, new Integer(freq)});
        }
        PrintStream out = new PrintStream(new FileOutputStream(this.wordFreqFile));
        for (Object[] tokenFreq : sortedFreqs) {
            String word = (String)tokenFreq[0];
            int freq = (Integer)tokenFreq[1];
            out.println(word + "|" + freq);
        }
        out.flush();
        out.close();
    }
}

