/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.sideeffect.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;

public class SEUtil {
    public static int[] getSentenceSpanContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int[] span = new int[]{-1, -1};
        while (iter.hasNext()) {
            Sentence sa = (Sentence)((Object)iter.next());
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            span[0] = sa.getBegin();
            span[1] = sa.getEnd();
            break;
        }
        return span;
    }

    public static String getSentenceTextContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        String str = "";
        while (iter.hasNext()) {
            Sentence sa = (Sentence)((Object)iter.next());
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            str = sa.getCoveredText().trim();
            break;
        }
        return str;
    }

    public static int[] getSentenceSpanOfGivenSentenceNum(JCas jcas, int senNum) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int[] span = new int[]{-1, -1};
        int num = 0;
        while (iter.hasNext()) {
            Sentence sa = (Sentence)((Object)iter.next());
            if (senNum == num) {
                span[0] = sa.getBegin();
                span[1] = sa.getEnd();
                break;
            }
            ++num;
        }
        return span;
    }

    public static String getSegmentIDOfSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        String segID = null;
        while (iter.hasNext()) {
            Sentence sa = (Sentence)((Object)iter.next());
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            segID = sa.getSegmentId();
            break;
        }
        return segID;
    }

    public static String getSegmentID(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Segment.type).iterator();
        String segID = null;
        while (iter.hasNext()) {
            Segment seg = (Segment)((Object)iter.next());
            if (seg.getBegin() > begin || seg.getEnd() < end) continue;
            segID = seg.getId();
            break;
        }
        return segID;
    }

    public static int contains(int b1, int e1, int b2, int e2) {
        if (b1 <= b2 && e1 >= e2) {
            return 1;
        }
        if (b2 <= b1 && e2 >= e1) {
            return 2;
        }
        return 0;
    }

    public static boolean intersects(int b1, int e1, int b2, int e2) {
        if (SEUtil.contains(b1, e1, b2, e2) != 0) {
            return true;
        }
        return b1 <= b2 && b2 < e1 || b2 <= b1 && b1 < e2;
    }

    public static List getDrugsInSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator neItr = indexes.getAnnotationIndex(IdentifiedAnnotation.type).iterator();
        ArrayList<IdentifiedAnnotation> l = new ArrayList<IdentifiedAnnotation>();
        while (neItr.hasNext()) {
            IdentifiedAnnotation nea = (IdentifiedAnnotation)((Object)neItr.next());
            if (nea.getTypeID() != 1 || nea.getBegin() < begin || nea.getEnd() > end) continue;
            l.add(nea);
        }
        return l;
    }

    public static int getSentenceNumContainingGivenSpan(JCas jcas, int begin, int end) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator iter = indexes.getAnnotationIndex(Sentence.type).iterator();
        int senNum = -1;
        while (iter.hasNext()) {
            Sentence sa = (Sentence)((Object)iter.next());
            if (begin < sa.getBegin() || end > sa.getEnd()) continue;
            senNum = sa.getSentenceNumber();
            break;
        }
        return senNum;
    }

    public static int getNumOfWordTokensInSpan(JCas jcas, int begin, int end) {
        HashSet<String> ignoreWords = new HashSet<String>();
        ignoreWords.add("and");
        ignoreWords.add("or");
        FSIterator wtIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)WordToken.type, (int)begin, (int)end);
        int cnt = 0;
        while (wtIter.hasNext()) {
            WordToken wt = (WordToken)((Object)wtIter.next());
            if (ignoreWords.contains(wt.getCoveredText().toLowerCase())) continue;
            ++cnt;
        }
        return cnt;
    }

    public static int getNumOfWordTokensInSpanExceptGivenNE(JCas jcas, int begin, int end, int neType) {
        HashSet<String> ignoreWords = new HashSet<String>();
        ignoreWords.add("and");
        ignoreWords.add("or");
        ArrayList<IdentifiedAnnotation> neLst = new ArrayList<IdentifiedAnnotation>();
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)begin, (int)(end + 1));
        while (neIter.hasNext()) {
            IdentifiedAnnotation ne = (IdentifiedAnnotation)((Object)neIter.next());
            if (ne.getTypeID() != neType) continue;
            neLst.add(ne);
        }
        FSIterator wtIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)WordToken.type, (int)begin, (int)end);
        int cnt = 0;
        while (wtIter.hasNext()) {
            WordToken wt = (WordToken)((Object)wtIter.next());
            if (ignoreWords.contains(wt.getCoveredText().toLowerCase())) continue;
            boolean isNE = false;
            for (IdentifiedAnnotation n : neLst) {
                if (n.getBegin() > wt.getBegin() || n.getEnd() < wt.getEnd()) continue;
                isNE = true;
                break;
            }
            if (isNE) continue;
            ++cnt;
        }
        return cnt;
    }

    public static boolean isUpperCaseString(String str) {
        for (int i = str.length() - 1; i > 0; --i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isInUpperCaseStringLine(JCas jcas, IdentifiedAnnotation nea) {
        boolean flag = false;
        int[] senSpan = SEUtil.getSentenceSpanContainingGivenSpan(jcas, nea.getBegin(), nea.getEnd());
        String senText = SEUtil.getSentenceTextContainingGivenSpan(jcas, nea.getBegin(), nea.getEnd());
        if (senText.indexOf(" - ") != -1) {
            return false;
        }
        FSIterator ntIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)NewlineToken.type, (int)senSpan[0], (int)(senSpan[1] + 2));
        while (ntIter.hasNext()) {
            NewlineToken nt = (NewlineToken)((Object)ntIter.next());
            if (senSpan[1] != nt.getBegin() || !SEUtil.isUpperCaseString(senText)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isSpanInSameLine(JCas jcas, int begin, int end) {
        FSIterator ntIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)NewlineToken.type, (int)begin, (int)(end - 1));
        return !ntIter.hasNext();
    }

    public static boolean isDrugBetween(JCas jcas, int begin, int end) {
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)begin, (int)(end + 1));
        while (neIter.hasNext()) {
            IdentifiedAnnotation ne = (IdentifiedAnnotation)((Object)neIter.next());
            if (ne.getTypeID() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isPSEBetween(JCas jcas, int begin, int end) {
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)begin, (int)(end + 1));
        while (neIter.hasNext()) {
            IdentifiedAnnotation ne = (IdentifiedAnnotation)((Object)neIter.next());
            if (ne.getTypeID() != 2 && ne.getTypeID() != 3) continue;
            return true;
        }
        return false;
    }

    public static JCas getJCasViewWithDefault(CAS cas, String name) throws CASException {
        JCas returnCas = null;
        Iterator viewItr = cas.getJCas().getViewIterator();
        while (viewItr.hasNext()) {
            JCas newJcas = (JCas)viewItr.next();
            if (!newJcas.getViewName().equals(name)) continue;
            returnCas = newJcas;
        }
        if (returnCas == null) {
            returnCas = cas.getJCas();
        }
        return returnCas;
    }
}

