/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonAuxArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class DoubleArrayFSImpl
extends CommonAuxArrayFSImpl
implements DoubleArrayFS {
    public DoubleArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator<DoubleArrayFSImpl> generator() {
        return new DoubleArrayGenerator();
    }

    @Override
    public double get(int i) {
        this.casImpl.checkArrayBounds(this.addr, i);
        return this.casImpl.ll_getDoubleArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, double val) {
        this.casImpl.checkArrayBounds(this.addr, i);
        this.casImpl.ll_setDoubleArrayValue(this.addr, i, val);
    }

    @Override
    public void copyFromArray(double[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.casImpl.ll_setDoubleArrayValue(this.addr, destOffset + i, src[srcOffset + i]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, double[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.casImpl.ll_getDoubleArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public double[] toArray() {
        int size = this.size();
        double[] outArray = new double[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Double.toString(this.casImpl.ll_getDoubleArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.casImpl.ll_setDoubleArrayValue(this.addr, destOffset + i, Double.parseDouble(src[i + srcOffset]));
        }
    }

    private static class DoubleArrayGenerator
    implements FSGenerator<DoubleArrayFSImpl> {
        private DoubleArrayGenerator() {
        }

        @Override
        public DoubleArrayFSImpl createFS(int addr, CASImpl cas) {
            return new DoubleArrayFSImpl(addr, cas);
        }
    }
}

