/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet;

import cc.mallet.fst.Transducer;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import java.util.ArrayList;
import java.util.List;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.SequenceClassifier_ImplBase;
import org.cleartk.util.ReflectionUtil;

public class MalletCrfStringOutcomeClassifier
extends SequenceClassifier_ImplBase<List<NameNumber>, String, String> {
    protected Transducer transducer;

    public MalletCrfStringOutcomeClassifier(FeaturesEncoder<List<NameNumber>> featuresEncoder, OutcomeEncoder<String, String> outcomeEncoder, Transducer transducer) {
        super(featuresEncoder, outcomeEncoder);
        this.transducer = transducer;
    }

    public List<String> classify(List<List<Feature>> features) throws CleartkProcessingException {
        String[][] featureStringArray = this.toStrings(features);
        Pipe pipe = this.transducer.getInputPipe();
        Instance instance = new Instance((Object)featureStringArray, null, null, null);
        instance = pipe.instanceFrom(instance);
        Sequence data = (Sequence)instance.getData();
        Sequence untypedSequence = this.transducer.transduce(data);
        Sequence sequence = (Sequence)ReflectionUtil.uncheckedCast((Object)untypedSequence);
        ArrayList<String> returnValues = new ArrayList<String>();
        for (int i = 0; i < sequence.size(); ++i) {
            String encodedOutcome = (String)sequence.get(i);
            returnValues.add((String)this.outcomeEncoder.decode((Object)encodedOutcome));
        }
        return returnValues;
    }

    private String[][] toStrings(List<List<Feature>> features) throws CleartkEncoderException {
        ArrayList encodedFeatures = new ArrayList(features.size());
        for (List<Feature> features1 : features) {
            List nameNumbers = (List)this.featuresEncoder.encodeAll(features1);
            ArrayList<String> encodedFeatures1 = new ArrayList<String>();
            for (NameNumber nameNumber : nameNumbers) {
                encodedFeatures1.add(nameNumber.name);
            }
            encodedFeatures.add(encodedFeatures1);
        }
        String[][] encodedFeaturesArray = new String[encodedFeatures.size()][];
        for (int i = 0; i < encodedFeatures.size(); ++i) {
            String[] encodedFeaturesArray1 = ((List)encodedFeatures.get(i)).toArray(new String[0]);
            encodedFeaturesArray[i] = encodedFeaturesArray1;
        }
        return encodedFeaturesArray;
    }
}

