/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.token.pos.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.factory.initializable.Initializable;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.function.CapitalTypeFeatureFunction;
import org.cleartk.ml.feature.function.CharacterNgramFeatureFunction;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.cleartk.ml.feature.function.FeatureFunctionExtractor;
import org.cleartk.ml.feature.function.LowerCaseFeatureFunction;
import org.cleartk.ml.feature.function.NumericTypeFeatureFunction;
import org.cleartk.token.pos.PosFeatureExtractor;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class DefaultFeatureExtractor
implements PosFeatureExtractor<Token, Sentence>,
Initializable {
    private List<FeatureExtractor1<Token>> simpleExtractors;
    private List<CleartkExtractor<Token, Token>> windowExtractors;
    private List<CleartkExtractor<Token, Token>> windowNGramExtractors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.simpleExtractors = Lists.newArrayList();
        CoveredTextExtractor wordExtractor = new CoveredTextExtractor();
        CharacterNgramFeatureFunction.Orientation fromLeft = CharacterNgramFeatureFunction.Orientation.LEFT_TO_RIGHT;
        CharacterNgramFeatureFunction.Orientation fromRight = CharacterNgramFeatureFunction.Orientation.RIGHT_TO_LEFT;
        this.simpleExtractors.add((FeatureExtractor1<Token>)new FeatureFunctionExtractor((FeatureExtractor1)wordExtractor, new FeatureFunction[]{new LowerCaseFeatureFunction(), new CapitalTypeFeatureFunction(), new NumericTypeFeatureFunction(), new CharacterNgramFeatureFunction(fromLeft, 0, 1), new CharacterNgramFeatureFunction(fromLeft, 0, 2), new CharacterNgramFeatureFunction(fromLeft, 0, 3), new CharacterNgramFeatureFunction(fromRight, 0, 1), new CharacterNgramFeatureFunction(fromRight, 0, 2), new CharacterNgramFeatureFunction(fromRight, 0, 3), new CharacterNgramFeatureFunction(fromRight, 0, 4), new CharacterNgramFeatureFunction(fromRight, 0, 5), new CharacterNgramFeatureFunction(fromRight, 0, 6)}));
        this.windowExtractors = Lists.newArrayList();
        this.windowExtractors.add((CleartkExtractor<Token, Token>)new CleartkExtractor(Token.class, (FeatureExtractor1)wordExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(2), new CleartkExtractor.Following(2)}));
        this.windowNGramExtractors = Lists.newArrayList();
        this.windowNGramExtractors.add((CleartkExtractor<Token, Token>)new CleartkExtractor(Token.class, (FeatureExtractor1)wordExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Ngram(new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(2)}), new CleartkExtractor.Ngram(new CleartkExtractor.Context[]{new CleartkExtractor.Following(2)})}));
    }

    @Override
    public List<Feature> extractFeatures(JCas jCas, Token token, Sentence sentence) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (FeatureExtractor1<Token> featureExtractor1 : this.simpleExtractors) {
            features.addAll(featureExtractor1.extract(jCas, (Annotation)token));
        }
        for (CleartkExtractor cleartkExtractor : this.windowExtractors) {
            features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
        }
        for (CleartkExtractor cleartkExtractor : this.windowNGramExtractors) {
            features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
        }
        return features;
    }
}

