/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.apache.ctakes.assertion.attributes.features.GenericFeaturesExtractor;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.ContextWordWindowExtractor;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;

@PipeBitInfo(name="Generic Status ClearTK Annotator", description="Annotates the Generic status for Identified Annotations.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class GenericCleartkAnalysisEngine
extends AssertionCleartkAnalysisEngine {
    boolean USE_DEFAULT_EXTRACTORS = false;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 0.5;
        this.initialize_generic_extractor();
        this.initializeFeatureSelection();
    }

    private void initialize_generic_extractor() {
        if (this.entityFeatureExtractors == null) {
            this.entityFeatureExtractors = new ArrayList();
        }
        this.entityFeatureExtractors.add(new ContextWordWindowExtractor("org/apache/ctakes/assertion/models/generic.txt"));
        this.entityFeatureExtractors.add(new GenericFeaturesExtractor());
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            boolean generic = entityOrEventMention.getGeneric();
            if (!generic && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)("" + generic));
        } else {
            String label = (String)this.classifier.classify(instance.getFeatures());
            entityOrEventMention.setGeneric(Boolean.parseBoolean(label));
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : GenericCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(GenericCleartkAnalysisEngine.class, (Object[])new Object[]{"classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return GenericCleartkAnalysisEngine.createAnnotatorDescription("/org/apache/ctakes/assertion/models/generic/model.jar");
    }
}

