/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;

@PipeBitInfo(name="ClearTK Conditional Annotator", description="Determines whether or not Identified Annotations are conditional.", dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class ConditionalCleartkAnalysisEngine
extends AssertionCleartkAnalysisEngine {
    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 1.0;
        this.initializeFeatureSelection();
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            boolean conditional = entityOrEventMention.getConditional();
            if (!conditional && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)("" + conditional));
        } else {
            String label = (String)this.classifier.classify(instance.getFeatures());
            boolean conditional = false;
            if (label != null) {
                conditional = Boolean.parseBoolean(label);
            }
            entityOrEventMention.setConditional(conditional);
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : ConditionalCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ConditionalCleartkAnalysisEngine.class, (Object[])new Object[]{"classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return ConditionalCleartkAnalysisEngine.createAnnotatorDescription("/org/apache/ctakes/assertion/models/conditional/model.jar");
    }
}

