/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.cr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.assertion.cr.ArgumentInfo;
import org.apache.ctakes.assertion.cr.RelationInfo;
import org.apache.ctakes.assertion.cr.Span;
import org.jdom.Document;
import org.jdom.Element;

public class XMLReader {
    static String[] attrHeadings = new String[]{"booleanSlotMention", "stringSlotMention"};
    private static boolean VERBOSE = true;

    public static HashMap<String, ArrayList<Span>> getEntityMentions(Document document) {
        HashMap<String, ArrayList<Span>> entityMentions = new HashMap<String, ArrayList<Span>>();
        Element elementRoot = document.getRootElement();
        List annotations = elementRoot.getChildren("annotation");
        for (int i = 0; i < annotations.size(); ++i) {
            Element elementAnnotation = (Element)annotations.get(i);
            List elementSpans = elementAnnotation.getChildren("span");
            if (elementSpans.size() == 0) continue;
            ArrayList<Span> spans = new ArrayList<Span>();
            for (int j = 0; j < elementSpans.size(); ++j) {
                Element elementSpan = (Element)elementSpans.get(j);
                String start = elementSpan.getAttributeValue("start");
                String end = elementSpan.getAttributeValue("end");
                Span span = new Span(Integer.parseInt(start), Integer.parseInt(end));
                spans.add(span);
            }
            String mentionId = elementAnnotation.getChild("mention").getAttributeValue("id");
            entityMentions.put(mentionId, spans);
        }
        return entityMentions;
    }

    public static HashMap<String, String> getEntityTypes(Document document) {
        HashMap<String, String> entityTypes = new HashMap<String, String>();
        Element root = document.getRootElement();
        List classMentions = root.getChildren("classMention");
        for (int i = 0; i < classMentions.size(); ++i) {
            Element classMention = (Element)classMentions.get(i);
            String id = classMention.getAttributeValue("id");
            String cl = classMention.getChildText("mentionClass");
            entityTypes.put(id, cl);
        }
        return entityTypes;
    }

    public static HashMap<String, List<String>> getEntityAttributes(Document document) {
        HashMap<String, List<String>> entityAttr = new HashMap<String, List<String>>();
        Element root = document.getRootElement();
        List classMentions = root.getChildren("classMention");
        for (int i = 0; i < classMentions.size(); ++i) {
            Element classMention = (Element)classMentions.get(i);
            String id = classMention.getAttributeValue("id");
            ArrayList<String> lsAttr = new ArrayList<String>();
            List lsSlotMention = classMention.getChildren("hasSlotMention");
            for (Object slotMention : lsSlotMention) {
                String slotid = ((Element)slotMention).getAttributeValue("id");
                lsAttr.add(slotid);
            }
            entityAttr.put(id, lsAttr);
        }
        return entityAttr;
    }

    public static HashMap<String, ArgumentInfo> getAttributes(Document document) {
        return XMLReader.getAttributes(document, attrHeadings);
    }

    public static HashMap<String, ArgumentInfo> getAttributes(Document document, String[] headings) {
        HashMap<String, ArgumentInfo> entityAttr = new HashMap<String, ArgumentInfo>();
        Element root = document.getRootElement();
        for (String heading : headings) {
            List slotMentions = root.getChildren(heading);
            for (int i = 0; i < slotMentions.size(); ++i) {
                Element complexSlotMention = (Element)slotMentions.get(i);
                String id = complexSlotMention.getAttributeValue("id");
                String value = complexSlotMention.getChild(heading + "Value").getAttributeValue("value");
                String attr = complexSlotMention.getChild("mentionSlot").getAttributeValue("id");
                if (entityAttr.containsKey(id)) {
                    if (VERBOSE) {
                        System.err.println("WARNING: found more than one attribute in an attribute mention");
                    }
                    entityAttr.put(id, new ArgumentInfo(value, XMLReader.normalizeName(attr)));
                    continue;
                }
                entityAttr.put(id, new ArgumentInfo(value, XMLReader.normalizeName(attr)));
            }
        }
        return entityAttr;
    }

    public static ArrayList<RelationInfo> getRelations(Document document) {
        ArrayList<RelationInfo> relations = new ArrayList<RelationInfo>();
        Element root = document.getRootElement();
        HashMap<String, ArgumentInfo> hashComplexSlotMentions = new HashMap<String, ArgumentInfo>();
        List complexSlotMentions = root.getChildren("complexSlotMention");
        for (int i = 0; i < complexSlotMentions.size(); ++i) {
            Element complexSlotMention = (Element)complexSlotMentions.get(i);
            String id = complexSlotMention.getAttributeValue("id");
            String value = complexSlotMention.getChild("complexSlotMentionValue").getAttributeValue("value");
            String role = complexSlotMention.getChild("mentionSlot").getAttributeValue("id");
            hashComplexSlotMentions.put(id, new ArgumentInfo(value, XMLReader.normalizeName(role)));
        }
        List classMentions = root.getChildren("classMention");
        for (int i = 0; i < classMentions.size(); ++i) {
            Element classMention = (Element)classMentions.get(i);
            List hasSlotMentions = classMention.getChildren("hasSlotMention");
            if (hasSlotMentions.size() < 2) continue;
            String relationType = classMention.getChildText("mentionClass");
            XMLReader.addRelation(relations, hasSlotMentions, hashComplexSlotMentions, relationType);
        }
        return relations;
    }

    private static void addRelation(ArrayList<RelationInfo> relations, List<?> hasSlotMentions, HashMap<String, ArgumentInfo> hashComplexSlotMentions, String relationType) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < hasSlotMentions.size(); ++i) {
            String role;
            String id = ((Element)hasSlotMentions.get(i)).getAttributeValue("id");
            if (!hashComplexSlotMentions.containsKey(id) || !(role = hashComplexSlotMentions.get((Object)id).role).equals("Argument") && !role.equals("Related_to")) continue;
            ids.add(id);
        }
        if (ids.size() != 2) {
            return;
        }
        String id1 = hashComplexSlotMentions.get(ids.get((int)0)).value;
        String role1 = hashComplexSlotMentions.get(ids.get((int)0)).role;
        String id2 = hashComplexSlotMentions.get(ids.get((int)1)).value;
        String role2 = hashComplexSlotMentions.get(ids.get((int)1)).role;
        relations.add(new RelationInfo(id1, id2, role1, role2, relationType));
    }

    private static String normalizeName(String role) {
        if (role.equals("Argument_CU")) {
            return "Argument";
        }
        if (role.equals("Related_to_CU")) {
            return "Related_to";
        }
        return role;
    }
}

