/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.eval;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.CausesBringsAboutRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.DegreeOfRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.LocationOfRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.ManagesTreatsRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.ManifestationOfRelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.eval.ParameterSettings;
import org.apache.ctakes.relationextractor.eval.SHARPXMI;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CausesBringsAboutTextRelation;
import org.apache.ctakes.typesystem.type.relation.DegreeOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.ManagesTreatsTextRelation;
import org.apache.ctakes.typesystem.type.relation.ManifestationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.util.ViewUriUtil;

public class RelationExtractorEvaluation
extends SHARPXMI.Evaluation_ImplBase {
    public static final Map<String, Class<? extends BinaryTextRelation>> RELATION_CLASSES = Maps.newHashMap();
    public static final Map<Class<? extends BinaryTextRelation>, Class<? extends RelationExtractorAnnotator>> ANNOTATOR_CLASSES = Maps.newHashMap();
    public static final Map<Class<? extends BinaryTextRelation>, ParameterSettings> BEST_PARAMETERS = Maps.newHashMap();
    private Class<? extends BinaryTextRelation> relationClass;
    private Class<? extends RelationExtractorAnnotator> classifierAnnotatorClass;
    private ParameterSettings parameterSettings;
    private boolean testOnCTakes;
    private boolean allowSmallerSystemArguments;
    private boolean ignoreImpossibleGoldRelations;
    private boolean printErrors;
    private boolean setClassWeights;
    private static PrintWriter outPrint;
    public static boolean expandEvent;

    public static void main(String[] args) throws Exception {
        final Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        SHARPXMI.validate(options);
        SHARPXMI.generateXMI(options);
        ArrayList gridOfSettings = Lists.newArrayList();
        for (float probabilityOfKeepingANegativeExample : new float[]{1.0f}) {
            for (int solver : new int[]{0, 1}) {
                for (double svmCost : new double[]{0.01, 0.05, 0.1, 0.5, 1.0, 5.0, 10.0, 50.0, 100.0}) {
                    gridOfSettings.add(new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new Object[]{"ProbabilityOfKeepingANegativeExample", Float.valueOf(probabilityOfKeepingANegativeExample)}, new String[]{"-s", String.valueOf(solver), "-c", String.valueOf(svmCost)}));
                }
            }
        }
        Object object = options.getRelations().iterator();
        while (object.hasNext()) {
            final String relationCategory = (String)object.next();
            final Class<? extends BinaryTextRelation> relationClass = RELATION_CLASSES.get(relationCategory);
            ParameterSettings bestSettings = BEST_PARAMETERS.get(relationClass);
            SHARPXMI.evaluate(options, bestSettings, gridOfSettings, new Function<ParameterSettings, RelationExtractorEvaluation>(){

                public RelationExtractorEvaluation apply(@Nullable ParameterSettings params) {
                    return new RelationExtractorEvaluation(new File("target/models/" + relationCategory), relationClass, ANNOTATOR_CLASSES.get(relationClass), params, options.getTestOnCTakes(), options.getAllowSmallerSystemArguments(), options.getIgnoreImpossibleGoldRelations(), options.getPrintErrors(), options.getClassWeights(), options.getExpandEvents());
                }
            });
        }
    }

    public RelationExtractorEvaluation(File baseDirectory, Class<? extends BinaryTextRelation> relationClass, Class<? extends RelationExtractorAnnotator> classifierAnnotatorClass, ParameterSettings parameterSettings, boolean testOnCTakes, boolean allowSmallerSystemArguments, boolean ignoreImpossibleGoldRelations, boolean printErrors, boolean setClassWeights, boolean expandEventParameter) {
        super(baseDirectory);
        this.relationClass = relationClass;
        this.classifierAnnotatorClass = classifierAnnotatorClass;
        this.parameterSettings = parameterSettings;
        this.testOnCTakes = testOnCTakes;
        this.allowSmallerSystemArguments = allowSmallerSystemArguments;
        this.ignoreImpossibleGoldRelations = ignoreImpossibleGoldRelations;
        this.printErrors = printErrors;
        this.setClassWeights = setClassWeights;
        expandEvent = expandEventParameter;
    }

    public RelationExtractorEvaluation(File baseDirectory, Class<? extends BinaryTextRelation> relationClass, Class<? extends RelationExtractorAnnotator> classifierAnnotatorClass, ParameterSettings parameterSettings) {
        this(baseDirectory, relationClass, classifierAnnotatorClass, parameterSettings, false, false, false, false, false, false);
    }

    public void train(CollectionReader collectionReader, File directory) throws Exception {
        System.err.printf("%s: %s: %s:\n", ((Object)((Object)this)).getClass().getSimpleName(), this.relationClass.getSimpleName(), directory.getName());
        System.err.println(this.parameterSettings);
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(RemoveCTakesMentionsAndCopyGoldRelations.class, (Object[])new Object[0]), new String[0]);
        if (expandEvent && this.relationClass.getSimpleName().equals("LocationOfTextRelation")) {
            builder.add(AnalysisEngineFactory.createEngineDescription(AddPotentialRelations.class, (Object[])new Object[0]), new String[0]);
        }
        AnalysisEngineDescription classifierAnnotator = AnalysisEngineFactory.createEngineDescription(this.classifierAnnotatorClass, (Object[])this.parameterSettings.configurationParameters);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)classifierAnnotator, (Object[])new Object[]{"dataWriterClassName", this.parameterSettings.dataWriterClass, "outputDirectory", directory.getPath()});
        builder.add(classifierAnnotator, new String[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        if (this.setClassWeights) {
            String[] weightArray = new String[RelationExtractorAnnotator.category_frequency.size() * 2];
            int weight_idx = 0;
            float baseFreq = RelationExtractorAnnotator.category_frequency.get("-NONE-").intValue();
            for (Map.Entry<String, Integer> entry : RelationExtractorAnnotator.category_frequency.entrySet()) {
                weightArray[weight_idx * 2] = "-w" + Integer.toString(weight_idx + 1);
                float weight = baseFreq / (float)entry.getValue().intValue();
                weightArray[weight_idx * 2 + 1] = Float.toString(weight);
                ++weight_idx;
                System.err.println("Category:" + entry.getKey() + "  freq:" + entry.getValue() + "   weight:" + weight);
            }
            LinkedList<String> parameters = new LinkedList<String>(Arrays.asList(this.parameterSettings.trainingArguments));
            List<String> additional = Arrays.asList(weightArray);
            parameters.addAll(additional);
            RelationExtractorAnnotator.clearCategoryFrequency();
            JarClassifierBuilder.trainAndPackage((File)directory, (String[])parameters.toArray(new String[parameters.size()]));
        } else {
            JarClassifierBuilder.trainAndPackage((File)directory, (String[])this.parameterSettings.trainingArguments);
        }
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder builder = new AggregateBuilder();
        if (this.testOnCTakes) {
            File file = new File("desc/analysis_engine/ModifierExtractorAnnotator.xml");
            XMLInputSource source = new XMLInputSource(file);
            builder.add(UIMAFramework.getXMLParser().parseAnalysisEngineDescription(source), new String[0]);
            builder.add(AnalysisEngineFactory.createEngineDescription(RemoveSmallerEventMentions.class, (Object[])new Object[0]), new String[0]);
        } else {
            builder.add(AnalysisEngineFactory.createEngineDescription(ReplaceCTakesMentionsWithGoldMentions.class, (Object[])new Object[0]), new String[0]);
        }
        AnalysisEngineDescription classifierAnnotator = AnalysisEngineFactory.createEngineDescription(this.classifierAnnotatorClass, (Object[])this.parameterSettings.configurationParameters);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)classifierAnnotator, (Object[])new Object[]{"classifierJarPath", JarClassifierBuilder.getModelJarFile((File)directory)});
        builder.add(classifierAnnotator, new String[0]);
        AnnotationStatistics stats = new AnnotationStatistics();
        Function<BinaryTextRelation, HashableArguments> getSpan = new Function<BinaryTextRelation, HashableArguments>(){

            public HashableArguments apply(BinaryTextRelation relation) {
                return new HashableArguments(relation);
            }
        };
        Function getOutcome = AnnotationStatistics.annotationToFeatureValue((String)"category");
        AnalysisEngine engine = builder.createAggregate();
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{engine});
        while (casIter.hasNext()) {
            Object relation2;
            JCas goldView;
            JCas jCas = (JCas)casIter.next();
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            Collection goldBinaryTextRelations = JCasUtil.select((JCas)goldView, this.relationClass);
            Collection systemBinaryTextRelations = JCasUtil.select((JCas)jCas, this.relationClass);
            if (this.ignoreImpossibleGoldRelations) {
                ArrayList relations = Lists.newArrayList();
                for (Object relation2 : goldBinaryTextRelations) {
                    boolean hasSystemArgs = true;
                    for (RelationArgument relArg2 : Lists.newArrayList((Object[])new RelationArgument[]{relation2.getArg1(), relation2.getArg2()})) {
                        IdentifiedAnnotation goldArg = (IdentifiedAnnotation)relArg2.getArgument();
                        Class<?> goldClass = goldArg.getClass();
                        boolean noSystemArg = JCasUtil.selectCovered((JCas)jCas, goldClass, (AnnotationFS)goldArg).isEmpty();
                        hasSystemArgs = hasSystemArgs && !noSystemArg;
                    }
                    if (hasSystemArgs) {
                        relations.add(relation2);
                        continue;
                    }
                    IdentifiedAnnotation arg1 = (IdentifiedAnnotation)relation2.getArg1().getArgument();
                    IdentifiedAnnotation arg2 = (IdentifiedAnnotation)relation2.getArg2().getArgument();
                    String messageFormat = "removing relation between %s and %s which is impossible to find with system mentions";
                    String message = String.format(messageFormat, RelationExtractorEvaluation.format(arg1), RelationExtractorEvaluation.format(arg2));
                    UIMAFramework.getLogger(((Object)((Object)this)).getClass()).log(Level.WARNING, message);
                }
                goldBinaryTextRelations = relations;
            }
            if (this.allowSmallerSystemArguments) {
                HashSet goldArgs = Sets.newHashSet();
                for (Object relation2 : goldBinaryTextRelations) {
                    for (Object relArg : Lists.newArrayList((Object[])new RelationArgument[]{relation2.getArg1(), relation2.getArg2()})) {
                        goldArgs.add((IdentifiedAnnotation)relArg.getArgument());
                    }
                }
                HashSet unmatchedSystemArgs = Sets.newHashSet();
                relation2 = systemBinaryTextRelations.iterator();
                while (relation2.hasNext()) {
                    Object relArg;
                    BinaryTextRelation relation3 = (BinaryTextRelation)relation2.next();
                    relArg = Lists.newArrayList((Object[])new RelationArgument[]{relation3.getArg1(), relation3.getArg2()}).iterator();
                    while (relArg.hasNext()) {
                        RelationArgument relArg2;
                        relArg2 = (RelationArgument)relArg.next();
                        IdentifiedAnnotation systemArg = (IdentifiedAnnotation)relArg2.getArgument();
                        Class<?> systemClass = systemArg.getClass();
                        boolean matchesSomeGold = false;
                        for (IdentifiedAnnotation goldArg : JCasUtil.selectCovered((JCas)goldView, systemClass, (AnnotationFS)systemArg)) {
                            if (goldArg.getBegin() != systemArg.getBegin() || goldArg.getEnd() != systemArg.getEnd()) continue;
                            matchesSomeGold = true;
                            break;
                        }
                        if (matchesSomeGold) continue;
                        unmatchedSystemArgs.add(systemArg);
                    }
                }
                HashMap systemToGold = Maps.newHashMap();
                for (IdentifiedAnnotation goldArg : goldArgs) {
                    Class<?> goldClass = goldArg.getClass();
                    for (IdentifiedAnnotation systemArg : JCasUtil.selectCovered((JCas)jCas, goldClass, (AnnotationFS)goldArg)) {
                        IdentifiedAnnotation other;
                        IdentifiedAnnotation current;
                        if (!unmatchedSystemArgs.contains(systemArg)) continue;
                        IdentifiedAnnotation oldGoldArg = (IdentifiedAnnotation)systemToGold.get(systemArg);
                        if (oldGoldArg == null) {
                            systemToGold.put(systemArg, goldArg);
                            continue;
                        }
                        if (systemArg.getTypeID() == goldArg.getTypeID()) {
                            systemToGold.put(systemArg, goldArg);
                            current = goldArg;
                            other = oldGoldArg;
                        } else {
                            current = oldGoldArg;
                            other = goldArg;
                        }
                        String message = "system argument %s mapped to gold argument %s, but could also be mapped to %s";
                        message = String.format(message, RelationExtractorEvaluation.format(systemArg), RelationExtractorEvaluation.format(current), RelationExtractorEvaluation.format(other));
                        UIMAFramework.getLogger(((Object)((Object)this)).getClass()).log(Level.WARNING, message);
                    }
                }
                for (BinaryTextRelation relation4 : systemBinaryTextRelations) {
                    for (RelationArgument relArg : Lists.newArrayList((Object[])new RelationArgument[]{relation4.getArg1(), relation4.getArg2()})) {
                        IdentifiedAnnotation systemArg;
                        systemArg = (IdentifiedAnnotation)relArg.getArgument();
                        IdentifiedAnnotation matchingGoldArg = (IdentifiedAnnotation)systemToGold.get(systemArg);
                        if (matchingGoldArg == null) continue;
                        String messageFormat = "replacing system argument %s with gold argument %s";
                        String message = String.format(messageFormat, RelationExtractorEvaluation.format(systemArg), RelationExtractorEvaluation.format(matchingGoldArg));
                        UIMAFramework.getLogger(((Object)((Object)this)).getClass()).log(Level.WARNING, message);
                        relArg.setArgument((Annotation)matchingGoldArg);
                    }
                }
            }
            stats.add(goldBinaryTextRelations, systemBinaryTextRelations, (Function)getSpan, getOutcome);
            if (!this.printErrors) continue;
            RelationExtractorEvaluation.printInstanceOutput(goldBinaryTextRelations, systemBinaryTextRelations, getSpan, (Function<BinaryTextRelation, String>)getOutcome);
            HashMap goldMap = Maps.newHashMap();
            for (Object relation2 : goldBinaryTextRelations) {
                goldMap.put(new HashableArguments((BinaryTextRelation)relation2), relation2);
            }
            HashMap systemMap = Maps.newHashMap();
            relation2 = systemBinaryTextRelations.iterator();
            while (relation2.hasNext()) {
                BinaryTextRelation relation5 = (BinaryTextRelation)relation2.next();
                systemMap.put(new HashableArguments(relation5), relation5);
            }
            Sets.SetView all = Sets.union(goldMap.keySet(), systemMap.keySet());
            ArrayList sorted = Lists.newArrayList((Iterable)all);
            Collections.sort(sorted);
            File noteFile = new File(ViewUriUtil.getURI((JCas)jCas).toString());
            String fileName = noteFile.getName();
            for (HashableArguments key : sorted) {
                BinaryTextRelation goldRelation = (BinaryTextRelation)goldMap.get(key);
                BinaryTextRelation systemRelation = (BinaryTextRelation)systemMap.get(key);
                if (goldRelation == null) {
                    System.out.printf("[%s] System added: %s\n", fileName, RelationExtractorEvaluation.formatRelation(systemRelation));
                    continue;
                }
                if (systemRelation == null) {
                    System.out.printf("[%s] System dropped: %s\n", fileName, RelationExtractorEvaluation.formatRelation(goldRelation));
                    continue;
                }
                if (!systemRelation.getCategory().equals(goldRelation.getCategory())) {
                    String label = systemRelation.getCategory();
                    System.out.printf("[%s] System labeled %s for %s\n", fileName, label, RelationExtractorEvaluation.formatRelation(systemRelation));
                    continue;
                }
                if (!systemRelation.getCategory().equals(goldRelation.getCategory())) continue;
                System.out.printf("[%s] System nailed it: %s\n", fileName, RelationExtractorEvaluation.formatRelation(systemRelation));
            }
        }
        System.err.print(stats);
        System.err.println();
        return stats;
    }

    private static void printInstanceOutput(Collection<? extends BinaryTextRelation> referenceAnnotations, Collection<? extends BinaryTextRelation> predictedAnnotations, Function<BinaryTextRelation, HashableArguments> annotationToSpan, Function<BinaryTextRelation, String> annotationToOutcome) {
        HashMap<Object, Object> referenceSpanOutcomes = new HashMap<Object, Object>();
        for (BinaryTextRelation binaryTextRelation : referenceAnnotations) {
            referenceSpanOutcomes.put(annotationToSpan.apply((Object)binaryTextRelation), annotationToOutcome.apply((Object)binaryTextRelation));
        }
        HashMap<Object, Object> predictedSpanOutcomes = new HashMap<Object, Object>();
        for (BinaryTextRelation binaryTextRelation : predictedAnnotations) {
            predictedSpanOutcomes.put(annotationToSpan.apply((Object)binaryTextRelation), annotationToOutcome.apply((Object)binaryTextRelation));
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(referenceSpanOutcomes.keySet());
        hashSet.addAll(predictedSpanOutcomes.keySet());
        File file = new File("target/locationOf_Instance_output_test.txt");
        try {
            outPrint = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            for (HashableArguments span : hashSet) {
                String goldCategory = (String)referenceSpanOutcomes.get(span);
                String predictedCategory = (String)predictedSpanOutcomes.get(span);
                if (goldCategory == null) {
                    outPrint.println("fp");
                    continue;
                }
                if (predictedCategory == null) {
                    outPrint.println("fn");
                    continue;
                }
                outPrint.println("tp");
            }
            outPrint.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String formatRelation(BinaryTextRelation relation) {
        IdentifiedAnnotation arg1 = (IdentifiedAnnotation)relation.getArg1().getArgument();
        IdentifiedAnnotation arg2 = (IdentifiedAnnotation)relation.getArg2().getArgument();
        String text = arg1.getCAS().getDocumentText();
        int begin = Math.min(arg1.getBegin(), arg2.getBegin());
        int end = Math.max(arg1.getBegin(), arg2.getBegin());
        begin = Math.max(0, begin - 50);
        end = Math.min(text.length(), end + 50);
        return String.format("%s(%s(type=%d), %s(type=%d)) in ...%s...", relation.getCategory(), arg1.getCoveredText(), arg1.getTypeID(), arg2.getCoveredText(), arg2.getTypeID(), text.substring(begin, end).replaceAll("[\r\n]", " "));
    }

    static String format(IdentifiedAnnotation a) {
        return a == null ? null : String.format("\"%s\"(type=%d)", a.getCoveredText(), a.getTypeID());
    }

    static {
        RELATION_CLASSES.put("degree_of", DegreeOfTextRelation.class);
        ANNOTATOR_CLASSES.put(DegreeOfTextRelation.class, DegreeOfRelationExtractorAnnotator.class);
        BEST_PARAMETERS.put(DegreeOfTextRelation.class, new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new Object[]{"ProbabilityOfKeepingANegativeExample", Float.valueOf(1.0f)}, new String[]{"-s", "1", "-c", "0.1"}));
        RELATION_CLASSES.put("location_of", LocationOfTextRelation.class);
        ANNOTATOR_CLASSES.put(LocationOfTextRelation.class, LocationOfRelationExtractorAnnotator.class);
        BEST_PARAMETERS.put(LocationOfTextRelation.class, new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new Object[]{"ProbabilityOfKeepingANegativeExample", Float.valueOf(1.0f)}, new String[]{"-s", "0", "-c", "50.0"}));
        RELATION_CLASSES.put("manages/treats", ManagesTreatsTextRelation.class);
        ANNOTATOR_CLASSES.put(ManagesTreatsTextRelation.class, ManagesTreatsRelationExtractorAnnotator.class);
        BEST_PARAMETERS.put(ManagesTreatsTextRelation.class, new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new Object[]{"ProbabilityOfKeepingANegativeExample", Float.valueOf(0.5f)}, new String[]{"-s", "0", "-c", "5.0"}));
        RELATION_CLASSES.put("causes/brings_about", CausesBringsAboutTextRelation.class);
        ANNOTATOR_CLASSES.put(CausesBringsAboutTextRelation.class, CausesBringsAboutRelationExtractorAnnotator.class);
        BEST_PARAMETERS.put(CausesBringsAboutTextRelation.class, new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new Object[]{"ProbabilityOfKeepingANegativeExample", Float.valueOf(0.5f)}, new String[]{"-s", "0", "-c", "1.0"}));
        RELATION_CLASSES.put("manifestation_of", ManifestationOfTextRelation.class);
        ANNOTATOR_CLASSES.put(ManifestationOfTextRelation.class, ManifestationOfRelationExtractorAnnotator.class);
        BEST_PARAMETERS.put(ManifestationOfTextRelation.class, new ParameterSettings(LibLinearStringOutcomeDataWriter.class, new Object[]{"ProbabilityOfKeepingANegativeExample", Float.valueOf(0.5f)}, new String[]{"-s", "0", "-c", "1.0"}));
        expandEvent = false;
    }

    public static class HashableArguments
    implements Comparable<HashableArguments> {
        protected int arg1begin;
        protected int arg1end;
        protected int arg2begin;
        protected int arg2end;

        public HashableArguments(int arg1begin, int arg1end, int arg2begin, int arg2end) {
            this.arg1begin = arg1begin;
            this.arg1end = arg1end;
            this.arg2begin = arg2begin;
            this.arg2end = arg2end;
        }

        public HashableArguments(Annotation arg1, Annotation arg2) {
            this(arg1.getBegin(), arg1.getEnd(), arg2.getBegin(), arg2.getEnd());
        }

        public HashableArguments(BinaryTextRelation relation) {
            this(relation.getArg1().getArgument(), relation.getArg2().getArgument());
        }

        public boolean equals(Object otherObject) {
            int ltrArgEnd;
            int ltrArgBegin;
            int preArgEnd;
            int preArgBegin;
            if (this.arg1begin < this.arg2begin) {
                preArgBegin = this.arg1begin;
                preArgEnd = this.arg1end;
                ltrArgBegin = this.arg2begin;
                ltrArgEnd = this.arg2end;
            } else {
                preArgBegin = this.arg2begin;
                preArgEnd = this.arg2end;
                ltrArgBegin = this.arg1begin;
                ltrArgEnd = this.arg1end;
            }
            boolean result = false;
            if (otherObject instanceof HashableArguments) {
                int otherLtrArgEnd;
                int otherLtrArgBegin;
                int otherPreArgEnd;
                int otherPreArgBegin;
                HashableArguments other = (HashableArguments)otherObject;
                if (other.arg1begin < other.arg2begin) {
                    otherPreArgBegin = other.arg1begin;
                    otherPreArgEnd = other.arg1end;
                    otherLtrArgBegin = other.arg2begin;
                    otherLtrArgEnd = other.arg2end;
                } else {
                    otherPreArgBegin = other.arg2begin;
                    otherPreArgEnd = other.arg2end;
                    otherLtrArgBegin = other.arg1begin;
                    otherLtrArgEnd = other.arg1end;
                }
                result = this.getClass() == other.getClass() && preArgBegin == otherPreArgBegin && preArgEnd == otherPreArgEnd && ltrArgBegin == otherLtrArgBegin && ltrArgEnd == otherLtrArgEnd;
            }
            return result;
        }

        public int hashCode() {
            int ltrArgEnd;
            int ltrArgBegin;
            int preArgEnd;
            int preArgBegin;
            if (this.arg1begin < this.arg2begin) {
                preArgBegin = this.arg1begin;
                preArgEnd = this.arg1end;
                ltrArgBegin = this.arg2begin;
                ltrArgEnd = this.arg2end;
            } else {
                preArgBegin = this.arg2begin;
                preArgEnd = this.arg2end;
                ltrArgBegin = this.arg1begin;
                ltrArgEnd = this.arg1end;
            }
            return Objects.hashCode((Object[])new Object[]{preArgBegin, preArgEnd, ltrArgBegin, ltrArgEnd});
        }

        public String toString() {
            return String.format("%s(%s,%s,%s,%s)", this.getClass().getSimpleName(), this.arg1begin, this.arg1end, this.arg2begin, this.arg2end);
        }

        @Override
        public int compareTo(HashableArguments that) {
            int thisBegin = Math.min(this.arg1begin, this.arg2begin);
            int thatBegin = Math.min(that.arg1begin, that.arg2begin);
            int thisEnd = Math.max(this.arg1end, this.arg2end);
            int thatEnd = Math.max(that.arg1end, that.arg2end);
            if (thisBegin < thatBegin) {
                return -1;
            }
            if (thisBegin > thatBegin) {
                return 1;
            }
            if (this.equals(that)) {
                return 0;
            }
            if (thisEnd < thatEnd) {
                return -1;
            }
            return 1;
        }
    }

    public static class RemoveSmallerEventMentions
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            Collection mentions = JCasUtil.select((JCas)jCas, EventMention.class);
            for (EventMention mention : Lists.newArrayList((Iterable)mentions)) {
                int begin = mention.getBegin();
                int end = mention.getEnd();
                int typeID = mention.getTypeID();
                List subMentions = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)mention);
                for (EventMention subMention : subMentions) {
                    if (subMention.getBegin() <= begin && subMention.getEnd() >= end || subMention.getTypeID() != typeID) continue;
                    String message = String.format("removed %s inside %s", RelationExtractorEvaluation.format((IdentifiedAnnotation)subMention), RelationExtractorEvaluation.format((IdentifiedAnnotation)mention));
                    this.getContext().getLogger().log(Level.WARNING, message);
                    subMention.removeFromIndexes();
                }
            }
        }
    }

    public static class ReplaceCTakesMentionsWithGoldMentions
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList cTakesMentions = new ArrayList();
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EventMention.class));
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EntityMention.class));
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, Modifier.class));
            for (IdentifiedAnnotation cTakesMention : cTakesMentions) {
                cTakesMention.removeFromIndexes();
            }
            ArrayList goldMentions = new ArrayList();
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EventMention.class));
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EntityMention.class));
            goldMentions.addAll(JCasUtil.select((JCas)goldView, Modifier.class));
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            for (IdentifiedAnnotation goldMention : goldMentions) {
                Annotation copy = (Annotation)copier.copyFs((FeatureStructure)goldMention);
                Feature sofaFeature = copy.getType().getFeatureByBaseName("sofa");
                copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                copy.addToIndexes();
            }
        }
    }

    public static class RemoveCTakesMentionsAndCopyGoldRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList cTakesMentions = new ArrayList();
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EventMention.class));
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EntityMention.class));
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, Modifier.class));
            for (IdentifiedAnnotation cTakesMention : cTakesMentions) {
                cTakesMention.removeFromIndexes();
            }
            ArrayList goldMentions = new ArrayList();
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EventMention.class));
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EntityMention.class));
            goldMentions.addAll(JCasUtil.select((JCas)goldView, Modifier.class));
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.cas.AnnotationBase:sofa");
            for (IdentifiedAnnotation goldMention : goldMentions) {
                Annotation copy = (Annotation)copier.copyFs((FeatureStructure)goldMention);
                copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                copy.addToIndexes();
            }
            for (BinaryTextRelation goldRelation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                BinaryTextRelation relation = (BinaryTextRelation)copier.copyFs((FeatureStructure)goldRelation);
                relation.addToIndexes(systemView);
                for (RelationArgument relArg : Lists.newArrayList((Object[])new RelationArgument[]{relation.getArg1(), relation.getArg2()})) {
                    relArg.addToIndexes(systemView);
                }
            }
        }
    }

    @PipeBitInfo(name="Location Relation Overlapper", description="Adds Location-Of relations for annotations overlapping those already having relations.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.LOCATION_RELATION})
    public static class AddPotentialRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas relationView = jCas;
            Map coveredMap = JCasUtil.indexCovered((JCas)relationView, EventMention.class, EventMention.class);
            ArrayList eventList = new ArrayList();
            for (LocationOfTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)relationView, LocationOfTextRelation.class))) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                EventMention event = null;
                if (arg1 instanceof EventMention && arg2 instanceof AnatomicalSiteMention) {
                    event = (EventMention)arg1;
                    eventList.addAll((Collection)coveredMap.get(event));
                    for (IdentifiedAnnotation covEvent : eventList) {
                        if (covEvent.getClass().equals(EventMention.class) || AddPotentialRelations.hasOverlap((Annotation)covEvent, arg2)) continue;
                        AddPotentialRelations.createRelation(relationView, (Annotation)covEvent, arg2, relation.getCategory());
                    }
                    eventList.clear();
                    continue;
                }
                if (!(arg2 instanceof EventMention) || !(arg1 instanceof AnatomicalSiteMention)) continue;
                event = (EventMention)arg2;
                eventList.addAll((Collection)coveredMap.get(event));
                for (IdentifiedAnnotation covEvent : eventList) {
                    if (covEvent.getClass().equals(EventMention.class) || AddPotentialRelations.hasOverlap(arg1, (Annotation)covEvent)) continue;
                    AddPotentialRelations.createRelation(relationView, arg1, (Annotation)covEvent, relation.getCategory());
                }
                eventList.clear();
            }
        }

        private static boolean hasOverlap(Annotation event1, Annotation event2) {
            if (event1.getEnd() >= event2.getBegin() && event1.getEnd() <= event2.getEnd()) {
                return true;
            }
            return event2.getEnd() >= event1.getBegin() && event2.getEnd() <= event1.getEnd();
        }

        private static void createRelation(JCas jCas, Annotation arg1, Annotation arg2, String category) {
            RelationArgument relArg1 = new RelationArgument(jCas);
            relArg1.setArgument(arg1);
            relArg1.setRole("Arg1");
            relArg1.addToIndexes();
            RelationArgument relArg2 = new RelationArgument(jCas);
            relArg2.setArgument(arg2);
            relArg2.setRole("Arg2");
            relArg2.addToIndexes();
            BinaryTextRelation relation = new BinaryTextRelation(jCas);
            relation.setArg1(relArg1);
            relation.setArg2(relArg2);
            relation.setCategory(category);
            relation.addToIndexes();
        }
    }

    public static interface Options
    extends SHARPXMI.EvaluationOptions {
        @Option(longName={"relations"}, description="determines which relations to evaluate on (separately)", defaultValue={"degree_of", "location_of"})
        public List<String> getRelations();

        @Option(longName={"test-on-ctakes"}, description="evaluate test performance on ctakes entities, instead of gold standard entities")
        public boolean getTestOnCTakes();

        @Option(longName={"allow-smaller-system-arguments"}, description="for evaluation, allow system relation arguments to match gold relation arguments that enclose them")
        public boolean getAllowSmallerSystemArguments();

        @Option(longName={"ignore-impossible-gold-relations"}, description="for evaluation, ignore gold relations that would be impossible to find because there are no corresponding system mentions")
        public boolean getIgnoreImpossibleGoldRelations();

        @Option(longName={"print-errors"}, description="print relations that were incorrectly predicted")
        public boolean getPrintErrors();

        @Option(longName={"class-weights"}, description="automatically set class-wise weights for inbalanced training data")
        public boolean getClassWeights();

        @Option(longName={"expand-events"}, description="expand events to their covering or covered events")
        public boolean getExpandEvents();
    }
}

