/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.chunking.BioChunking;
import org.cleartk.ml.chunking.Chunking;

@PipeBitInfo(name="Modifier Extractor", description="Annotates Modifiers and Chunks.", dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.SENTENCE}, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.CHUNK})
public class ModifierExtractorAnnotator
extends CleartkAnnotator<String> {
    private Chunking<String, BaseToken, Modifier> chunking;
    private int nPreviousClassifications = 2;

    public static AnalysisEngineDescription getDescription(Object ... additionalConfiguration) throws ResourceInitializationException {
        AnalysisEngineDescription desc = AnalysisEngineFactory.createEngineDescription(ModifierExtractorAnnotator.class, (Object[])new Object[0]);
        if (additionalConfiguration.length > 0) {
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)desc, (Object[])additionalConfiguration);
        }
        return desc;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        RelationExtractorAnnotator.allowClassifierModelOnClasspath(context);
        super.initialize(context);
        this.chunking = new BioChunking(BaseToken.class, Modifier.class, "typeID");
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List<Object> outcomes;
            ArrayList<BaseToken> tokens = new ArrayList<BaseToken>();
            for (BaseToken token : JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence)) {
                if (token instanceof NewlineToken) continue;
                tokens.add(token);
            }
            if (this.isTraining()) {
                List modifiers = JCasUtil.selectCovered((JCas)jCas, Modifier.class, (AnnotationFS)sentence);
                outcomes = this.chunking.createOutcomes(jCas, tokens, modifiers);
            } else {
                outcomes = new ArrayList();
            }
            int outcomeIndex = -1;
            for (BaseToken token : tokens) {
                ++outcomeIndex;
                ArrayList<Feature> features = new ArrayList<Feature>();
                features.add(new Feature((Object)token.getCoveredText()));
                features.add(new Feature("PartOfSpeech", (Object)token.getPartOfSpeech()));
                for (int i = this.nPreviousClassifications; i > 0; --i) {
                    int index = outcomeIndex - i;
                    String previousOutcome = index < 0 ? "O" : (String)outcomes.get(index);
                    features.add(new Feature("PreviousOutcome_" + i, (Object)previousOutcome));
                }
                if (this.isTraining()) {
                    String outcome = (String)outcomes.get(outcomeIndex);
                    this.dataWriter.write(new Instance((Object)outcome, features));
                    continue;
                }
                outcomes.add(this.classifier.classify(features));
            }
            if (this.isTraining()) continue;
            this.chunking.createChunks(jCas, tokens, outcomes);
        }
    }
}

