/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.xcas_comparison;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ctakes.utils.xcas_comparison.Const;
import org.apache.ctakes.utils.xcas_comparison.XcasAnnotation;
import org.apache.ctakes.utils.xcas_comparison.XcasFile;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XcasProcessor
extends DefaultHandler {
    private Locator loc;
    private SAXParser sp;
    private XcasFile xcasf;
    private Hashtable<String, Integer> pendingRef = new Hashtable();
    private Hashtable<Integer, int[]> pendingArr = new Hashtable();
    private Hashtable<Integer, int[]> pendingIntArr = new Hashtable();
    private HashMap<Integer, int[]> pendingList = new HashMap();
    private String parentTag;
    private int arrID;
    private int arrInd = -1;
    private StringBuffer val = new StringBuffer();

    @Override
    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
    }

    public XcasProcessor() {
        try {
            this.sp = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XcasFile process(File f) {
        this.xcasf = new XcasFile(f);
        this.pendingRef.clear();
        this.pendingArr.clear();
        this.pendingIntArr.clear();
        this.pendingList.clear();
        this.val.delete(0, this.val.length());
        this.arrInd = -1;
        try {
            this.sp.parse(f, (DefaultHandler)this);
        }
        catch (SAXParseException spe) {
            System.err.println("Error parsing XCAS file: " + f + " at line" + spe.getLineNumber());
            System.err.println(spe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.xcasf;
    }

    public XcasFile process(String f) {
        return this.process(new File(f));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.val.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.val.delete(0, this.val.length());
        String s = attributes.getValue(Const.ID);
        if (s == null) {
            return;
        }
        int id = Integer.parseInt(s);
        if (qName.equalsIgnoreCase(Const.UIMA_FSARRAY)) {
            this.pendingArr.put(id, new int[Integer.parseInt(attributes.getValue(Const.UIMA_ARRAY_SIZE_KEYWORD))]);
            this.parentTag = qName;
            this.arrID = id;
            this.arrInd = 0;
        } else if (qName.equalsIgnoreCase(Const.UIMA_INTARRAY)) {
            this.pendingIntArr.put(id, new int[Integer.parseInt(attributes.getValue(Const.UIMA_ARRAY_SIZE_KEYWORD))]);
            this.parentTag = qName;
            this.arrID = id;
            this.arrInd = 0;
        } else if (qName.equalsIgnoreCase(Const.UIMA_NONEMPTY_FSLIST)) {
            int[] ref = new int[]{Integer.parseInt(attributes.getValue(Const.UIMA_LIST_HEAD_KEYWORD)), Integer.parseInt(attributes.getValue(Const.UIMA_LIST_TAIL_KEYWORD))};
            this.pendingList.put(id, ref);
        } else if (qName.equalsIgnoreCase(Const.UIMA_EMPTY_FSLIST)) {
            this.pendingList.put(id, null);
        } else if (!qName.equalsIgnoreCase(Const.UIMA_ARRAY_INDEX_KEYWORD)) {
            XcasAnnotation a = new XcasAnnotation(qName);
            for (int i = attributes.getLength(); i > 0; --i) {
                String q = attributes.getQName(i - 1);
                String v = attributes.getValue(i - 1);
                if (q.equalsIgnoreCase(Const.ID) || Const.ATTRIBUTES_TO_IGNORE.contains(q)) continue;
                if (q.startsWith(Const.REF_PREFIX)) {
                    this.pendingRef.put(Integer.toString(id) + ":" + q, Integer.parseInt(v));
                    continue;
                }
                a.insertAttribute(q, v);
            }
            this.xcasf.addAnnotation(id, a, this.loc.getLineNumber() + ":" + this.loc.getColumnNumber());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block17: {
            block15: {
                block16: {
                    if (!qName.equalsIgnoreCase(Const.UIMA_ARRAY_INDEX_KEYWORD)) break block15;
                    if (!this.parentTag.equalsIgnoreCase(Const.UIMA_FSARRAY)) break block16;
                    this.pendingArr.get((Object)Integer.valueOf((int)this.arrID))[this.arrInd++] = Integer.parseInt(this.val.toString());
                    break block17;
                }
                if (!this.parentTag.equalsIgnoreCase(Const.UIMA_INTARRAY)) break block17;
                this.pendingIntArr.get((Object)Integer.valueOf((int)this.arrID))[this.arrInd++] = Integer.parseInt(this.val.toString());
                break block17;
            }
            if (qName.equalsIgnoreCase(Const.UIMA_FSARRAY)) {
                this.arrInd = -1;
            } else if (qName.equalsIgnoreCase(Const.UIMA_INTARRAY)) {
                this.arrInd = -1;
            } else if (qName.equalsIgnoreCase(Const.UIMA_CAS)) {
                for (String s : this.pendingRef.keySet()) {
                    int[] arr;
                    String[] ref = s.split(":");
                    int refID = this.pendingRef.get(s);
                    XcasAnnotation a = this.xcasf.getAnnotation(Integer.parseInt(ref[0]));
                    if (this.pendingIntArr.containsKey(refID)) {
                        a.insertIntReference(ref[1], this.pendingIntArr.get(refID));
                        continue;
                    }
                    if (this.pendingArr.containsKey(refID)) {
                        arr = this.pendingArr.get(refID);
                    } else if (this.pendingList.containsKey(refID)) {
                        LinkedList<Integer> ll = new LinkedList<Integer>();
                        int[] l = this.pendingList.get(refID);
                        while (l != null) {
                            ll.add(l[0]);
                            l = this.pendingList.get(l[1]);
                        }
                        arr = new int[ll.size()];
                        for (int i = 0; i < arr.length; ++i) {
                            arr[i] = (Integer)ll.get(i);
                        }
                    } else {
                        arr = new int[]{refID};
                    }
                    for (int i : arr) {
                        a.insertReference(ref[1], this.xcasf.getAnnotation(i));
                    }
                }
            }
        }
        if (this.val.length() > 0 && !qName.equalsIgnoreCase(Const.UIMA_ARRAY_INDEX_KEYWORD) && !qName.equalsIgnoreCase(Const.UIMA_TCAS_DOCUMENT)) {
            System.err.println("Unexpected text (" + qName + "): \"" + this.val.toString() + "\"");
        }
        this.val.delete(0, this.val.length());
    }
}

