/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.xcas_comparison;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.ctakes.utils.xcas_comparison.Const;
import org.apache.ctakes.utils.xcas_comparison.XcasAnnotation;
import org.apache.ctakes.utils.xcas_comparison.XcasFile;

public class XcasDiff {
    private XcasFile f1;
    private XcasFile f2;
    private LinkedList<XcasAnnotation> f1_uniq = new LinkedList();
    private LinkedList<XcasAnnotation> f2_uniq = new LinkedList();
    private LinkedList<XcasAnnotation> common = new LinkedList();

    public XcasDiff() {
    }

    public XcasDiff(XcasFile xf1, XcasFile xf2) {
        this();
        this.f1 = xf1;
        this.f2 = xf2;
        this.recalculate();
    }

    public final void recalculate() {
        this.f1_uniq.clear();
        this.f2_uniq.clear();
        this.common.clear();
        LinkedList<XcasAnnotation> l1 = this.f1.annotationsClone();
        LinkedList<XcasAnnotation> l2 = this.f2.annotationsClone();
        for (XcasAnnotation a : l1) {
            if (l2.contains(a)) {
                this.common.add(a);
                l2.remove(a);
                continue;
            }
            this.f1_uniq.add(a);
        }
        this.f2_uniq.addAll(l2);
        Collections.sort(this.f1_uniq);
        Collections.sort(this.f2_uniq);
        Collections.sort(this.common);
    }

    public void printCommon() {
        for (XcasAnnotation a : this.common) {
            System.out.println(a.description());
        }
    }

    public void printDiff() {
        try {
            System.out.println("-------- Unique to " + this.f1.f.getCanonicalFile().toString() + " --------");
            this.printUniq(1);
            System.out.println("-------- Unique to " + this.f2.f.getCanonicalFile().toString() + " --------");
            this.printUniq(2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printUniq(int i) {
        XcasFile f;
        LinkedList<XcasAnnotation> toPrint;
        if (i == 1) {
            toPrint = this.f1_uniq;
            f = this.f1;
        } else if (i == 2) {
            toPrint = this.f2_uniq;
            f = this.f2;
        } else {
            System.err.println("Not a legal file number: " + i);
            return;
        }
        for (XcasAnnotation a : toPrint) {
            System.out.println(a.shortType() + " ~@" + f.getPositionOther(a) + "  " + (a.shortType().equals(Const.UIMA_SOFA) ? Const.HIDDEN_TEXT : a.allFieldsValues()));
        }
    }

    public void printHTML(Writer w) {
        BufferedWriter bw = new BufferedWriter(w);
        try {
            String fName1 = this.f1.f.getCanonicalFile().toString();
            String fName2 = this.f2.f.getCanonicalFile().toString();
            bw.write("<html>");
            bw.newLine();
            bw.write("  <head>");
            bw.newLine();
            bw.write("    <title>Comparison of " + fName1 + " and " + fName2 + "</title>");
            bw.newLine();
            bw.write("    <script language=\"javascript\">");
            bw.newLine();
            bw.write("      function toggle_agreements() {");
            bw.newLine();
            bw.write("        var ele = document.getElementById('xcasdiff');");
            bw.newLine();
            bw.write("        if ((ele.rows[1].style.display=='none')) {");
            bw.newLine();
            bw.write("          for (i=1;i<" + (this.common.size() + 1) + ";i++) ele.rows[i].style.display='';");
            bw.newLine();
            bw.write("        } else {");
            bw.newLine();
            bw.write("          for (i=1;i<" + (this.common.size() + 1) + ";i++) ele.rows[i].style.display='none';");
            bw.newLine();
            bw.write("        }");
            bw.newLine();
            bw.write("      }");
            bw.newLine();
            bw.write("    </script>");
            bw.newLine();
            bw.write("  </head>");
            bw.newLine();
            bw.write("<body>");
            bw.newLine();
            bw.write("<p><button onClick=\"toggle_agreements()\">Toggle Aggreements</button> Click this button to show or hide agreements.</p>");
            bw.newLine();
            bw.write("<p>Positions are <i>approximate</i> line and column numbers of the element in a file. Yellow background cells indicate a similar element in a file without an exact match. A \"null\" means no similar match found.</p>");
            bw.newLine();
            bw.write("<p>File 1: <a href=\"file://" + fName1 + "\">" + fName1 + "</a><br>");
            bw.newLine();
            bw.write("File 2: <a href=\"file://" + fName2 + "\">" + fName2 + "</a></p>");
            bw.newLine();
            bw.write("<p>Agreed on " + this.common.size() + " elements.");
            bw.newLine();
            bw.write("File 1 has " + this.f1_uniq.size() + " unique elements, and file 2 has " + this.f2_uniq.size() + " unique elements.</p>");
            bw.newLine();
            bw.write("<table border=\"1\" id=\"xcasdiff\">");
            bw.newLine();
            bw.write("<tr>");
            bw.newLine();
            bw.write("<th></th>");
            bw.newLine();
            bw.write("<th>Element</th>");
            bw.newLine();
            bw.write("<th>Attributes</th>");
            bw.newLine();
            bw.write("<th>Position in File 1</th>");
            bw.newLine();
            bw.write("<th>Position in File 2</th>");
            bw.newLine();
            bw.write("</tr>");
            bw.newLine();
            int i = 0;
            for (XcasAnnotation a : this.common) {
                bw.write("<tr>");
                bw.newLine();
                if (i++ == 0) {
                    bw.write("<th rowspan=\"" + this.common.size() + "\">Agreements</th>");
                    bw.newLine();
                }
                bw.write("<td>" + a.shortType() + "</td>");
                bw.newLine();
                bw.write("<td>" + (a.type.equals(Const.UIMA_SOFA) ? Const.HIDDEN_TEXT : a.allFieldsValues()) + "</td>");
                bw.newLine();
                bw.write("<td>" + this.f1.getPositionOther(a) + "</td>");
                bw.newLine();
                bw.write("<td>" + this.f2.getPositionOther(a) + "</td>");
                bw.newLine();
            }
            if (i > 0) {
                bw.write("</tr>");
                bw.newLine();
                i = 0;
            }
            for (XcasAnnotation a : this.f1_uniq) {
                bw.write("<tr>");
                bw.newLine();
                if (i++ == 0) {
                    bw.write("<th rowspan=\"" + (this.f1_uniq.size() + this.f2_uniq.size()) + "\">Disagreements</th>");
                    bw.newLine();
                }
                bw.write("<td>" + a.shortType() + "</td>");
                bw.newLine();
                bw.write("<td>" + (a.type.equals(Const.UIMA_SOFA) ? Const.HIDDEN_TEXT : a.allFieldsValues()) + "</td>");
                bw.newLine();
                bw.write("<td>" + this.f1.getPositionOther(a) + "</td>");
                bw.newLine();
                bw.write("<td bgcolor=\"yellow\">" + this.f2.getPositionSimilar(a) + "</td>");
                bw.newLine();
            }
            for (XcasAnnotation a : this.f2_uniq) {
                bw.write("<tr>");
                bw.newLine();
                bw.write("<td>" + a.shortType() + "</td>");
                bw.newLine();
                bw.write("<td>" + (a.type.equals(Const.UIMA_SOFA) ? Const.HIDDEN_TEXT : a.allFieldsValues()) + "</td>");
                bw.newLine();
                bw.write("<td bgcolor=\"yellow\">" + this.f1.getPositionSimilar(a) + "</td>");
                bw.newLine();
                bw.write("<td>" + this.f2.getPositionOther(a) + "</td>");
                bw.newLine();
            }
            if (i > 0) {
                bw.write("</tr>");
                bw.newLine();
            }
            bw.write("</table>");
            bw.newLine();
            bw.write("</body>");
            bw.newLine();
            bw.write("</html>");
            bw.newLine();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printDiff(XcasFile f1, XcasFile f2) {
        new XcasDiff(f1, f2).printDiff();
    }

    public static void printHTML(XcasFile f1, XcasFile f2, Writer w) {
        new XcasDiff(f1, f2).printHTML(w);
    }
}

