/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.utils.wiki;

public class ApproximateMath {
    private static int numRoots;
    private static float[] roots;
    private static int cacheHit;
    private static int cacheMiss;
    private static int numLogs;
    private static float[] logs;

    public static final double asqrt(int i) {
        if (i < numRoots) {
            ++cacheHit;
            return roots[i];
        }
        ++cacheMiss;
        return Math.sqrt(i);
    }

    public static final double asqrt(double d) {
        if (d < (double)numRoots) {
            return roots[(int)d];
        }
        return Math.sqrt(d);
    }

    public static final double alog(double d) {
        if (d < (double)numLogs) {
            ++cacheHit;
            return logs[(int)d];
        }
        ++cacheMiss;
        return Math.log(d);
    }

    public static void dumpCache() {
        System.out.println(cacheHit + " cache hits");
        System.out.println(cacheMiss + " cache misses");
    }

    static {
        int i;
        numRoots = 10000;
        roots = new float[numRoots];
        cacheHit = 0;
        cacheMiss = 0;
        numLogs = 10000;
        logs = new float[numLogs];
        for (i = 0; i < numRoots; ++i) {
            ApproximateMath.roots[i] = (float)Math.sqrt(i);
        }
        for (i = 0; i < numLogs; ++i) {
            ApproximateMath.logs[i] = (float)Math.log(i);
        }
    }
}

