/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.token.breakit;

import java.lang.reflect.Constructor;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class BreakIteratorAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_LOCALE = "locale";
    @ConfigurationParameter(name="locale", description="provides the name of the locale to be used to instantiate the break iterator")
    private Locale locale;
    public static final String PARAM_BREAK_ITERATOR_TYPE = "breakIteratorType";
    @ConfigurationParameter(name="breakIteratorType", description="provides the type of the locale to be used to instantiate the break iterator.  Should be one of  'WORD' or 'SENTENCE'", defaultValue={"SENTENCE"})
    private BreakIteratorType breakIteratorType;
    public static final String PARAM_ANNOTATION_TYPE_NAME = "annotationTypeName";
    @ConfigurationParameter(name="annotationTypeName", description="class type of the annotations that are created by this annotator.")
    private String annotationTypeName;
    private Class<? extends Annotation> annotationClass;
    private Constructor<? extends Annotation> annotationConstructor;
    private BreakIterator breakIterator;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.annotationClass = InitializableFactory.getClass((String)this.annotationTypeName, Annotation.class);
            this.annotationConstructor = this.annotationClass.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.breakIterator = this.breakIteratorType == BreakIteratorType.WORD ? BreakIterator.getWordInstance(this.locale) : BreakIterator.getSentenceInstance(this.locale);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int endIndex;
        String text = jCas.getDocumentText();
        this.breakIterator.setText(text);
        int index = this.breakIterator.first();
        while ((endIndex = this.breakIterator.next()) != -1) {
            String annotationText = text.substring(index, endIndex);
            if (!annotationText.trim().equals("")) {
                try {
                    this.annotationConstructor.newInstance(jCas, index, endIndex).addToIndexes();
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            index = endIndex;
        }
    }

    public static enum BreakIteratorType {
        WORD,
        SENTENCE;

    }
}

