/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.sideeffect.ae;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.sideeffect.type.PSESentence;
import org.apache.ctakes.sideeffect.type.PSESentenceFeature;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;

public class SESentenceFeatureAnnotator
extends JCasAnnotator_ImplBase {
    private Map metaKeywords;
    private List metaKey;

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        this.metaKey = new ArrayList();
        try {
            String metaKeywordsFileName = (String)annotCtx.getConfigParameterValue("MetaKeywordsFile");
            this.metaKeywords = this.readMetaKeywordsFromFile(metaKeywordsFileName, this.metaKey);
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String docName = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
        System.out.println("---" + docName + "---");
        this.annotatePSESentenceFeatures(jcas);
    }

    private void annotatePSESentenceFeatures(JCas jcas) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        for (PSESentence ps : indexes.getAnnotationIndex(PSESentence.type)) {
            ArrayList fea = new ArrayList();
            fea.addAll(this.getLocationFeaturesFromMetaKeywords(jcas, ps));
            PSESentenceFeature psf = new PSESentenceFeature(jcas);
            StringArray feaArray = new StringArray(jcas, fea.size());
            for (int i = 0; i < fea.size(); ++i) {
                feaArray.set(i, (String)fea.get(i));
            }
            if (feaArray != null) {
                psf.setFeatures(feaArray);
            }
            psf.setPseSen(ps);
            psf.addToIndexes();
        }
    }

    private List getLocationFeaturesFromMetaKeywords(JCas jcas, PSESentence ps) {
        ArrayList<String> feature = new ArrayList<String>();
        ArrayList<IdentifiedAnnotation> drug = new ArrayList<IdentifiedAnnotation>();
        ArrayList<IdentifiedAnnotation> pse = new ArrayList<IdentifiedAnnotation>();
        FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)ps.getBegin(), (int)(ps.getEnd() + 1));
        while (neIter.hasNext()) {
            IdentifiedAnnotation n = (IdentifiedAnnotation)((Object)neIter.next());
            if (n.getTypeID() == 1) {
                drug.add(n);
            }
            if (n.getTypeID() != 2 && n.getTypeID() != 3) continue;
            pse.add(n);
        }
        for (String mk : this.metaKey) {
            Set kwSet = (Set)this.metaKeywords.get(mk);
            Iterator kwIter = kwSet.iterator();
            String kw = "";
            int kwPos = -1;
            boolean foundKw = false;
            while (kwIter.hasNext()) {
                String pseSenText = ps.getCoveredText().toLowerCase();
                kwPos = pseSenText.indexOf(kw = (String)kwIter.next());
                if (kwPos == -1) continue;
                int kwB = kwPos - 1;
                int kwA = kwPos + kw.length();
                if (pseSenText.length() > kwA && (kwPos != 0 || !pseSenText.substring(kwA, kwA + 1).matches("\\W")) && (!pseSenText.substring(kwA, kwA + 1).matches("\\W") || !pseSenText.substring(kwB, kwB + 1).matches("\\W"))) continue;
                foundKw = true;
                break;
            }
            if (!foundKw) {
                feature.add("nul");
                continue;
            }
            int kwBegin = kwPos + ps.getBegin();
            int kwEnd = kwBegin + kw.length();
            boolean beforePse = false;
            boolean afterPse = false;
            boolean betweenPseAndDrug = false;
            boolean betweenDrugAndPse = false;
            for (IdentifiedAnnotation pseNE : pse) {
                if (kwBegin > pseNE.getEnd()) {
                    for (IdentifiedAnnotation drugNE : drug) {
                        if (kwEnd >= drugNE.getBegin()) continue;
                        betweenPseAndDrug = true;
                        break;
                    }
                }
                if (!betweenPseAndDrug) continue;
                break;
            }
            for (IdentifiedAnnotation drugNE : drug) {
                if (kwBegin > drugNE.getEnd()) {
                    for (IdentifiedAnnotation pseNE : pse) {
                        if (kwEnd >= pseNE.getBegin()) continue;
                        betweenDrugAndPse = true;
                        break;
                    }
                }
                if (!betweenDrugAndPse) continue;
                break;
            }
            if (!betweenPseAndDrug && !betweenDrugAndPse) {
                for (IdentifiedAnnotation n : pse) {
                    if (kwEnd < n.getBegin()) {
                        beforePse = true;
                    }
                    if (kwBegin <= n.getEnd()) continue;
                    afterPse = true;
                }
            }
            if (mk.equals("SideEffectWord")) {
                feature.add("pre");
                continue;
            }
            if (betweenPseAndDrug && betweenDrugAndPse) {
                feature.add("bet");
                continue;
            }
            if (betweenPseAndDrug) {
                feature.add("bpd");
                continue;
            }
            if (betweenDrugAndPse) {
                feature.add("bdp");
                continue;
            }
            if (beforePse && afterPse) {
                feature.add("bap");
                continue;
            }
            if (beforePse) {
                feature.add("bep");
                continue;
            }
            if (afterPse) {
                feature.add("afp");
                continue;
            }
            feature.add("any");
        }
        return feature;
    }

    public Map readMetaKeywordsFromFile(String fileName, List key) throws IOException {
        String line;
        LinkedHashMap returnValues = new LinkedHashMap();
        File file = new File(fileName);
        BufferedReader fileReader = new BufferedReader(new FileReader(file));
        while ((line = fileReader.readLine()) != null) {
            if (line.startsWith("//") || line.length() == 0) continue;
            String[] stk = line.trim().split("\\|");
            LinkedHashSet<String> keySet = new LinkedHashSet<String>();
            for (int i = 1; i < stk.length; ++i) {
                keySet.add(stk[i].trim());
            }
            key.add(stk[0].trim());
            returnValues.put(stk[0].trim(), keySet);
        }
        return returnValues;
    }

    private class SideEffect {
        String text;
        int begin;
        int end;

        private SideEffect() {
        }
    }
}

