/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.MetaDataHit;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.phrasebuilder.PhraseBuilder;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;

public class DirectPassThroughImpl
implements LookupAlgorithm {
    private DictionaryEngine iv_dictEngine;
    private PhraseBuilder iv_phrBuilder;

    public DirectPassThroughImpl(DictionaryEngine dictEngine, PhraseBuilder phraseBuilder) {
        this.iv_dictEngine = dictEngine;
        this.iv_phrBuilder = phraseBuilder;
    }

    @Override
    public Collection<LookupHit> lookup(List<LookupToken> lookupTokenList, Map<String, List<LookupAnnotation>> contextMap) throws Exception {
        ArrayList<LookupHit> lhList = new ArrayList<LookupHit>();
        for (int tokenIdx = 0; tokenIdx < lookupTokenList.size(); ++tokenIdx) {
            LookupToken lt = lookupTokenList.get(tokenIdx);
            ArrayList<LookupToken> singleLtList = new ArrayList<LookupToken>();
            singleLtList.add(lt);
            String[] strArr = this.iv_phrBuilder.getPhrases(singleLtList);
            Collection<MetaDataHit> mdhCol = this.getHits(strArr);
            if (mdhCol == null || mdhCol.size() <= 0) continue;
            for (MetaDataHit mdh : mdhCol) {
                LookupHit lh = new LookupHit(mdh, lt.getStartOffset(), lt.getEndOffset());
                lhList.add(lh);
            }
        }
        return lhList;
    }

    private Collection<MetaDataHit> getHits(String[] phrases) throws Exception {
        ArrayList<MetaDataHit> mdhCol = new ArrayList<MetaDataHit>();
        for (int i = 0; i < phrases.length; ++i) {
            Collection<MetaDataHit> curMdhCol = this.iv_dictEngine.metaLookup(phrases[i]);
            if (curMdhCol.size() <= 0) continue;
            mdhCol.addAll(curMdhCol);
        }
        return mdhCol;
    }
}

