/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.chunker.ae.adjuster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Chunk Adjuster", description="Annotator that uses a pattern and a rule about that pattern to adjust certain annotations.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.CHUNK})
public class ChunkAdjuster
extends JCasAnnotator_ImplBase {
    public static final String PARAM_CHUNK_PATTERN = "ChunkPattern";
    @ConfigurationParameter(name="ChunkPattern", mandatory=true, description="The pattern of chunks that trigger an adjustment")
    private String[] chunksTypesInPattern;
    public static final String PARAM_EXTEND_TO_INCLUDE_TOKEN = "IndexOfTokenToInclude";
    @ConfigurationParameter(name="IndexOfTokenToInclude", mandatory=true, description="The index of the token in the pattern to extend to the end offset")
    private int indexOfTokenToInclude;
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.configInit();
    }

    private void configInit() throws ResourceInitializationException {
        if (this.indexOfTokenToInclude < 0 || this.indexOfTokenToInclude >= this.chunksTypesInPattern.length) {
            Object[] msgArgs = new String[]{Integer.toString(this.indexOfTokenToInclude), PARAM_EXTEND_TO_INCLUDE_TOKEN};
            throw new ResourceInitializationException("annotator_parameter_not_valid", msgArgs);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.logger.info((Object)" process(JCas)");
        try {
            Collection sentences = JCasUtil.select((JCas)jcas, Sentence.class);
            for (Sentence sentence : sentences) {
                this.annotateSentence(jcas, sentence);
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected void annotateSentence(JCas jcas, Sentence sent) throws AnalysisEngineProcessException {
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>(JCasUtil.selectCovered((JCas)jcas, Chunk.class, (AnnotationFS)sent));
        for (int i = 0; i < chunkList.size(); ++i) {
            boolean matches = true;
            Chunk chunk = (Chunk)chunkList.get(i);
            while (matches) {
                matches = this.compareToPattern(chunkList, i);
                if (!matches) continue;
                ChunkAdjuster.extendChunk(chunk, ((Chunk)chunkList.get(i + this.indexOfTokenToInclude)).getEnd());
                this.removeEnvelopedChunks(chunkList, i);
            }
        }
    }

    protected void annotateRange(JCas jcas, int rangeBegin, int rangeEnd) throws AnalysisEngineProcessException {
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>(JCasUtil.selectCovered((JCas)jcas, Chunk.class, (int)rangeBegin, (int)rangeEnd));
        for (int i = 0; i < chunkList.size(); ++i) {
            boolean matches = true;
            Chunk chunk = (Chunk)chunkList.get(i);
            while (matches) {
                matches = this.compareToPattern(chunkList, i);
                if (!matches) continue;
                ChunkAdjuster.extendChunk(chunk, ((Chunk)chunkList.get(i + this.indexOfTokenToInclude)).getEnd());
                this.removeEnvelopedChunks(chunkList, i);
            }
        }
    }

    private void removeEnvelopedChunks(List<Chunk> list, int i) {
        for (int j = 0; j < this.indexOfTokenToInclude; ++j) {
            list.remove(i + 1);
        }
    }

    private boolean compareToPattern(List<Chunk> list, int i) {
        boolean match = true;
        int len = list.size();
        for (int j = 0; j < this.chunksTypesInPattern.length; ++j) {
            if (i + j < len && list.get(i + j).getChunkType().equals(this.chunksTypesInPattern[j])) continue;
            match = false;
            break;
        }
        return match;
    }

    private static Chunk extendChunk(Chunk chunk, int newEnd) throws AnalysisEngineProcessException {
        if (newEnd < chunk.getBegin()) {
            Exception e = new Exception("New end offset (" + newEnd + ") < begin offset (" + chunk.getBegin() + ").");
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        chunk.setEnd(newEnd);
        return chunk;
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String[] chunkPattern, int patternIndex) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ChunkAdjuster.class, (Object[])new Object[]{PARAM_CHUNK_PATTERN, chunkPattern, PARAM_EXTEND_TO_INCLUDE_TOKEN, patternIndex});
    }
}

