/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.user;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.pipeline.bit.user.UserBit;

public final class UserBitListModel
extends AbstractListModel<UserBit> {
    private static final Logger LOGGER = Logger.getLogger("UserBitListModel");
    private UserBit _readerBit = null;
    private final List<UserBit> _userBits = new ArrayList<UserBit>();

    private void setReaderBit(UserBit reader) {
        if (this._readerBit != null) {
            this._readerBit = reader;
            this.fireContentsChanged(this, 0, 0);
            return;
        }
        this._readerBit = reader;
        this.fireIntervalAdded(this, 0, 0);
    }

    public void addUserBit(UserBit userBit) {
        this.insertUserBit(this.getSize(), userBit);
    }

    private void insertUserBit(int viewIndex, UserBit userBit) {
        if (userBit.getPipeBitInfo().role() == PipeBitInfo.Role.READER) {
            this.setReaderBit(userBit);
            return;
        }
        int listIndex = viewIndex;
        if (this._readerBit != null) {
            listIndex = viewIndex - 1;
        }
        this._userBits.add(listIndex, userBit);
        this.fireIntervalAdded(this, viewIndex, viewIndex);
    }

    public void moveUserBitUp(int viewIndex) {
        if (viewIndex >= this.getSize()) {
            LOGGER.warning("No User Pipe Bit at index " + viewIndex);
            return;
        }
        int listIndex = viewIndex;
        if (this._readerBit != null) {
            listIndex = viewIndex - 1;
        }
        if (listIndex <= 0) {
            return;
        }
        UserBit userBit = this._userBits.get(listIndex);
        this._userBits.remove(listIndex);
        this._userBits.add(listIndex - 1, userBit);
    }

    public void moveUserBitDown(int viewIndex) {
        if (viewIndex >= this.getSize()) {
            LOGGER.warning("No User Pipe Bit at index " + viewIndex);
            return;
        }
        int listIndex = viewIndex;
        if (this._readerBit != null) {
            listIndex = viewIndex - 1;
        }
        if (listIndex < 0 || listIndex >= this._userBits.size() - 1) {
            return;
        }
        UserBit userBit = this._userBits.get(listIndex);
        this._userBits.remove(listIndex);
        this._userBits.add(listIndex + 1, userBit);
    }

    public void removeUserBit(int viewIndex) {
        if (viewIndex >= this.getSize()) {
            LOGGER.warning("No User Pipe Bit at index " + viewIndex);
            return;
        }
        int listIndex = viewIndex;
        if (this._readerBit != null) {
            if (viewIndex == 0) {
                this._readerBit = null;
                return;
            }
            listIndex = viewIndex - 1;
        }
        this._userBits.remove(listIndex);
    }

    public UserBit getUserBit(int viewIndex) {
        int listIndex = viewIndex;
        if (this._readerBit != null) {
            if (viewIndex == 0) {
                return this._readerBit;
            }
            listIndex = viewIndex - 1;
        }
        return this._userBits.get(listIndex);
    }

    @Override
    public int getSize() {
        return this._userBits.size() + (this._readerBit == null ? 0 : 1);
    }

    @Override
    public UserBit getElementAt(int index) {
        return this.getUserBit(index);
    }
}

