/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.info;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.pipeline.bit.BitInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.available.AvailablesListModel;
import org.apache.ctakes.gui.pipeline.bit.parameter.DefaultParameterHolder;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterInfoPanel;
import org.apache.log4j.Logger;

public final class PipeBitInfoPanel
extends BitInfoPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"PipeBitInfoPanel");

    public void setPipeBitInfoList(JList<PipeBitInfo> pipeBitList) {
        pipeBitList.getSelectionModel().addListSelectionListener(new PipeBitListListener(pipeBitList));
    }

    @Override
    protected String getNameLabelPrefix() {
        return "Pipe";
    }

    @Override
    protected JComponent createNameEditor() {
        return new JLabel();
    }

    @Override
    protected void setBitName(String text, String toolTip) {
        ((JLabel)this._name).setText(text);
        this._name.setToolTipText(toolTip);
    }

    @Override
    protected ParameterInfoPanel createParameterInfoPanel() {
        return new ParameterInfoPanel();
    }

    private void setPipeBit(PipeBitInfo info, Class<?> pipeBitClass) {
        if (info == null) {
            this.clear();
            return;
        }
        this._pipeBitInfo = info;
        this._pipeBitClass = pipeBitClass;
        this.setBitName(info.name(), pipeBitClass.getName());
        this.setLabelText(this._description, info.description(), this._pipeBitInfo.description());
        String dependencies = Arrays.stream(this._pipeBitInfo.dependencies()).map(PipeBitInfo.TypeProduct::toString).collect(Collectors.joining(", "));
        this.setLabelText(this._dependencies, dependencies, dependencies);
        String usables = Arrays.stream(this._pipeBitInfo.usables()).map(PipeBitInfo.TypeProduct::toString).collect(Collectors.joining(", "));
        this.setLabelText(this._usables, usables, usables);
        String products = Arrays.stream(this._pipeBitInfo.products()).map(PipeBitInfo.TypeProduct::toString).collect(Collectors.joining(", "));
        this.setLabelText(this._products, products, products);
        DefaultParameterHolder holder = new DefaultParameterHolder(pipeBitClass);
        this._parameterTableModel.setParameterHolder(holder);
        this._parameterInfoPanel.setParameterHolder(holder);
    }

    private class PipeBitListListener
    implements ListSelectionListener {
        private final JList<PipeBitInfo> __pipeBitList;

        private PipeBitListListener(JList<PipeBitInfo> pipeBitList) {
            this.__pipeBitList = pipeBitList;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            PipeBitInfo pipeBitInfo = this.__pipeBitList.getSelectedValue();
            PipeBitInfoPanel.this.setPipeBit(pipeBitInfo, ((AvailablesListModel)this.__pipeBitList.getModel()).getPipeBit(pipeBitInfo));
        }
    }
}

