/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.component.FileTableCellEditor;
import org.apache.ctakes.gui.component.SmoothTipTable;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterCellRenderer;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterTableModel;
import org.apache.log4j.Logger;
import org.apache.uima.fit.descriptor.ConfigurationParameter;

public abstract class BitInfoPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"BitInfoPanel");
    protected PipeBitInfo _pipeBitInfo;
    protected Class<?> _pipeBitClass;
    protected JComponent _name;
    protected JLabel _description;
    protected JLabel _dependencies;
    protected JLabel _usables;
    protected JLabel _products;
    protected ParameterTableModel _parameterTableModel;
    protected ParameterInfoPanel _parameterInfoPanel;

    public BitInfoPanel() {
        super(new BorderLayout(5, 5));
        this.add((Component)this.createMainPanel(), "North");
        this._parameterTableModel = new ParameterTableModel();
        JTable parameterTable = BitInfoPanel.createParameterTable(this._parameterTableModel);
        this.add((Component)new JScrollPane(parameterTable), "Center");
        this._parameterInfoPanel = this.createParameterInfoPanel();
        this._parameterInfoPanel.setParameterTable(parameterTable);
        this.add((Component)this._parameterInfoPanel, "South");
    }

    public final PipeBitInfo getPipeBitInfo() {
        return this._pipeBitInfo;
    }

    public final Class<?> getPipeBitClass() {
        return this._pipeBitClass;
    }

    public final String getBitName() {
        return ((JLabel)this._name).getText();
    }

    public final String getDescription() {
        return this._description.getText();
    }

    public final ParameterTableModel getParameterModel() {
        return this._parameterTableModel;
    }

    protected abstract String getNameLabelPrefix();

    protected abstract JComponent createNameEditor();

    protected abstract void setBitName(String var1, String var2);

    protected abstract ParameterInfoPanel createParameterInfoPanel();

    protected void clear() {
        this._pipeBitInfo = null;
        this._pipeBitClass = null;
        this.setBitName("", "");
        this.clear(this._description);
        this.clear(this._dependencies);
        this.clear(this._usables);
        this.clear(this._products);
        this._parameterTableModel.setParameterHolder(null);
        this._parameterInfoPanel.setParameterHolder(null);
    }

    protected void clear(JLabel label) {
        this.setLabelText(label, "", "");
    }

    protected void setLabelText(JLabel label, String text, String toolTip) {
        label.setText(text);
        label.setToolTipText(toolTip);
    }

    private JComponent createMainPanel() {
        this._name = this.createNameEditor();
        JComponent namePanel = BitInfoPanel.createNamePanel(this.getNameLabelPrefix() + " Bit Name:", this._name);
        this._description = new JLabel();
        JComponent descPanel = BitInfoPanel.createNamePanel("Description:", this._description);
        this._dependencies = new JLabel();
        JComponent inPanel = BitInfoPanel.createNamePanel("Dependencies:", this._dependencies);
        this._usables = new JLabel();
        JComponent usablePanel = BitInfoPanel.createNamePanel("Usable:", this._usables);
        this._products = new JLabel();
        JComponent outPanel = BitInfoPanel.createNamePanel("Products:", this._products);
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.add(namePanel);
        panel.add(descPanel);
        panel.add(inPanel);
        panel.add(usablePanel);
        panel.add(outPanel);
        return panel;
    }

    private static JTable createParameterTable(TableModel model) {
        SmoothTipTable table = new SmoothTipTable(model);
        table.setRowHeight(20);
        table.setAutoResizeMode(3);
        table.getColumnModel().getColumn(0).setPreferredWidth(100);
        table.getColumnModel().getColumn(2).setMaxWidth(25);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model);
        table.setAutoCreateRowSorter(true);
        table.setRowSorter(sorter);
        table.setRowSelectionAllowed(true);
        table.setCellSelectionEnabled(true);
        table.setDefaultRenderer(ConfigurationParameter.class, new ParameterCellRenderer());
        FileTableCellEditor fileEditor = new FileTableCellEditor();
        fileEditor.getFileChooser().setFileSelectionMode(2);
        table.setDefaultRenderer(File.class, fileEditor);
        table.setDefaultEditor(File.class, fileEditor);
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setSelectionMode(0);
        return table;
    }

    private static JComponent createNamePanel(String name, JComponent nameLabel) {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(new EmptyBorder(2, 10, 2, 10));
        JLabel label = new JLabel(name);
        label.setPreferredSize(new Dimension(90, 20));
        label.setHorizontalAlignment(11);
        EmptyBorder emptyBorder = new EmptyBorder(0, 10, 0, 0);
        CompoundBorder border = new CompoundBorder(UIManager.getLookAndFeelDefaults().getBorder("TextField.border"), emptyBorder);
        nameLabel.setBorder(border);
        panel.add((Component)label, "West");
        panel.add((Component)nameLabel, "Center");
        return panel;
    }
}

