/*
 * Decompiled with CFR 0.152.
 */
package net.openai.util.fsm;

import java.io.Serializable;
import java.util.Vector;
import net.openai.util.fsm.State;
import net.openai.util.fsm.UnhandledConditionException;
import net.openai.util.fsm.event.MachineEvent;
import net.openai.util.fsm.event.MachineListener;

public class Machine
implements Serializable {
    private State startState = null;
    private State currentState = null;
    private Integer syncObject = new Integer(-1);
    private Vector listeners = new Vector();

    public Machine() {
    }

    public Machine(State startState) {
        this.setStartState(startState);
    }

    public final void addMachineListener(MachineListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add null listener.");
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.addElement(listener);
            }
        }
    }

    public final void removeMachineListener(MachineListener listener) {
        if (listener == null) {
            return;
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(listener);
        }
    }

    private void fireMachineEvent(int type) {
        Vector toFireTo = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            toFireTo = (Vector)this.listeners.clone();
        }
        int numListeners = toFireTo.size();
        int i = 0;
        while (i < numListeners) {
            ((MachineListener)toFireTo.elementAt(i)).handleMachineEvent(new MachineEvent(this, type));
            ++i;
        }
    }

    public final void setStartState(State state) {
        if (state == null) {
            throw new NullPointerException("Null start state");
        }
        Integer n = this.syncObject;
        synchronized (n) {
            if (this.startState != null) {
                this.startState.setStartStateFlag(false);
            }
            this.startState = state;
            this.startState.setStartStateFlag(true);
        }
    }

    public final State getStartState() {
        State returnValue = null;
        Integer n = this.syncObject;
        synchronized (n) {
            returnValue = this.startState;
        }
        return returnValue;
    }

    protected final void setCurrentState(State state) {
        Integer n = this.syncObject;
        synchronized (n) {
            this.currentState = state;
        }
    }

    public final State getCurrentState() {
        State returnValue = null;
        Integer n = this.syncObject;
        synchronized (n) {
            returnValue = this.currentState;
        }
        return returnValue;
    }

    public final void input(Object condition) throws UnhandledConditionException {
        Integer n = this.syncObject;
        synchronized (n) {
            State newState;
            if (this.currentState == null) {
                this.currentState = this.startState;
            }
            if ((newState = this.currentState.input(condition)) == null) {
                throw new UnhandledConditionException(this.currentState, condition);
            }
            Object stateData = this.currentState.exitState();
            this.currentState = newState;
            this.currentState.enterState(stateData);
        }
    }

    public final void input(boolean condition) throws UnhandledConditionException {
        this.input(new Boolean(condition));
    }

    public final void input(byte condition) throws UnhandledConditionException {
        this.input(new Byte(condition));
    }

    public final void input(char condition) throws UnhandledConditionException {
        this.input(new Character(condition));
    }

    public final void input(double condition) throws UnhandledConditionException {
        this.input(new Double(condition));
    }

    public final void input(float condition) throws UnhandledConditionException {
        this.input(new Float(condition));
    }

    public final void input(int condition) throws UnhandledConditionException {
        this.input(new Integer(condition));
    }

    public final void input(long condition) throws UnhandledConditionException {
        this.input(new Long(condition));
    }

    public final void input(short condition) throws UnhandledConditionException {
        this.input(new Short(condition));
    }

    public final void reset() {
        this.reset(false, false);
    }

    public final void reset(boolean asTransition, boolean nullifyInput) {
        Integer n = this.syncObject;
        synchronized (n) {
            if (asTransition) {
                Object stateData = null;
                if (this.currentState != null) {
                    stateData = this.currentState.exitState();
                }
                this.currentState = this.startState;
                if (nullifyInput) {
                    stateData = null;
                }
                if (this.currentState != null) {
                    this.currentState.enterState(stateData);
                }
            } else {
                this.currentState = this.startState;
            }
        }
    }
}

