/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.renderkit.dom_html_basic.BaseInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeWriter;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class TextareaRenderer
extends BaseInputRenderer {
    protected static final String ONMOUSEDOWN_FOCUS = "this.focus();";
    private static final String[] passThruExcludes = new String[]{"rows", "cols", "onmousedown"};
    private static final String[] passThruAttributes = AttributeConstants.getAttributes(8, passThruExcludes);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeBegin(facesContext, uiComponent);
        DomBasicRenderer.validateParameters(facesContext, uiComponent, UIInput.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        writer.startElement("textarea", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        this.renderHtmlAttributes(facesContext, writer, uiComponent);
        PassThruAttributeWriter.renderBooleanAttributes(writer, uiComponent, PassThruAttributeWriter.EMPTY_STRING_ARRAY);
        Object styleClass = uiComponent.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        this.renderNumericAttributeOrDefault(writer, uiComponent, "rows", "2");
        this.renderNumericAttributeOrDefault(writer, uiComponent, "cols", "20");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeChildren(facesContext, uiComponent);
        DomBasicRenderer.validateParameters(facesContext, uiComponent, UIInput.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        String currentValue = this.getValue(facesContext, uiComponent);
        if (currentValue != null && currentValue.length() > 0) {
            writer.writeText((Object)currentValue, null);
        }
        writer.endElement("textarea");
    }

    protected void renderNumericAttributeOrDefault(ResponseWriter writer, UIComponent uiComponent, String attribName, String defaultValue) throws IOException {
        Object val = uiComponent.getAttributes().get(attribName);
        if (val == null || (Integer)val <= -1) {
            val = defaultValue;
        }
        writer.writeAttribute(attribName, val, attribName);
    }

    protected void renderHtmlAttributes(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        PassThruAttributeWriter.renderHtmlAttributes(writer, uiComponent, passThruAttributes);
        String app = (String)uiComponent.getAttributes().get("onmousedown");
        String rend = ONMOUSEDOWN_FOCUS;
        String combined = DomBasicRenderer.combinedPassThru(app, rend);
        writer.writeAttribute("onmousedown", (Object)combined, "onmousedown");
    }
}

