/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.context.DOMResponseWriter;
import org.icefaces.impl.util.DOMUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMContext
implements Serializable {
    private static Logger log = Logger.getLogger(DOMContext.class.getName());
    private transient DOMResponseWriter writer;
    private Node cursor;
    private Document document;
    private Node rootNode;
    private Node parentElement;
    private boolean initialized;
    private static String DOM_CONTEXTS = "com.icesoft.faces.domcontext";

    protected DOMContext(DOMResponseWriter writer, Document document, Node parentElement) {
        this.writer = writer;
        this.document = document;
        this.cursor = parentElement;
        this.parentElement = parentElement;
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static DOMContext attachDOMContext(FacesContext facesContext, UIComponent component) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (!(responseWriter instanceof DOMResponseWriter)) {
            log.severe("ICEfaces rendering required by icefaces-compat.jar components. Enable via <icecore:config render=\"true\" />.");
            throw new UnsupportedOperationException("ICEfaces rendering required.");
        }
        DOMResponseWriter domWriter = (DOMResponseWriter)responseWriter;
        Node cursorParent = domWriter.getCursorParent();
        Document doc = domWriter.getDocument();
        Map domContexts = DOMContext.getDOMContexts(facesContext);
        DOMContext context = null;
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        if (clientId != null && domContexts.containsKey(clientId)) {
            context = (DOMContext)domContexts.get(clientId);
        }
        if (null == context) {
            context = new DOMContext(domWriter, doc, cursorParent);
            domContexts.put(clientId, context);
        }
        if (context.isInitialized()) {
            if (!(cursorParent instanceof Element)) {
                context.stepOver();
                return context;
            }
            context.attach((Element)cursorParent);
        }
        context.stepOver();
        return context;
    }

    public static DOMContext reattachDOMContext(FacesContext facesContext, UIComponent component) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        DOMResponseWriter domWriter = responseWriter instanceof DOMResponseWriter ? (DOMResponseWriter)responseWriter : DOMContext.createTemporaryDOMResponseWriter(responseWriter, facesContext);
        Document doc = domWriter.getDocument();
        Map domContexts = DOMContext.getDOMContexts(facesContext);
        DOMContext context = null;
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        if (domContexts.containsKey(clientId)) {
            context = (DOMContext)domContexts.get(clientId);
        }
        if (null == context) {
            Node cursorParent = domWriter.getCursorParent();
            context = new DOMContext(domWriter, doc, cursorParent);
            domContexts.put(clientId, context);
        } else {
            domWriter.setCursorParent(context.getRootNode());
        }
        return context;
    }

    private static DOMResponseWriter createTemporaryDOMResponseWriter(ResponseWriter responseWriter, FacesContext facesContext) {
        throw new UnsupportedOperationException("createTemporaryDOMResponseWriter not implemented");
    }

    public static Map getDOMContexts(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap domContexts = (HashMap)requestMap.get(DOM_CONTEXTS);
        if (null == domContexts) {
            domContexts = new HashMap();
            requestMap.put(DOM_CONTEXTS, domContexts);
        }
        return domContexts;
    }

    public static DOMContext getDOMContext(FacesContext facesContext, UIComponent component) {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        if (!(responseWriter instanceof DOMResponseWriter)) {
            log.severe("ICEfaces rendering required by icefaces-compat.jar components. Enable via <icecore:config render=\"true\" />.");
            throw new UnsupportedOperationException("ICEfaces rendering required.");
        }
        DOMResponseWriter domWriter = (DOMResponseWriter)responseWriter;
        Document doc = domWriter.getDocument();
        Map domContexts = DOMContext.getDOMContexts(facesContext);
        DOMContext context = null;
        String clientId = component.getClientId(FacesContext.getCurrentInstance());
        if (domContexts.containsKey(clientId)) {
            context = (DOMContext)domContexts.get(clientId);
        }
        if (null == context) {
            Node cursorParent = domWriter.getCursorParent();
            context = new DOMContext(domWriter, doc, cursorParent);
            domContexts.put(clientId, context);
        }
        return context;
    }

    private void attach(Element cursorParent) {
        if (null == this.rootNode) {
            return;
        }
        if (this.rootNode.equals(cursorParent)) {
            return;
        }
        if (this.rootNode.getParentNode() != cursorParent) {
            try {
                cursorParent.appendChild(this.rootNode);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    public Element createElement(String name) {
        return this.document.createElement(name);
    }

    public Text createTextNode(String cData) {
        return this.document.createTextNode(DOMUtils.escapeAnsi((String)cData));
    }

    public Text createTextNodeUnescaped(String cData) {
        return this.document.createTextNode(cData);
    }

    public void setRootNode(Node rootNode) {
        this.rootNode = rootNode;
        this.parentElement.appendChild(rootNode);
        this.initialized = true;
    }

    public Element createRootElement(String name) {
        Element rootElement = this.createElement(name);
        this.setRootNode(rootElement);
        return rootElement;
    }

    void setIsolatedRootNode(Node rootElement) {
        this.rootNode = rootElement;
        this.initialized = true;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
        this.writer.setCursorParent(cursorParent);
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    public void stepOver() {
        if (null != this.rootNode && this.rootNode.getParentNode() != null) {
            this.setCursorParent(this.rootNode.getParentNode());
        }
    }

    public void stepInto(UIComponent component) {
        if (this.rootNode != null) {
            this.setCursorParent(this.rootNode);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public static void removeChildren(Node parent) {
        while (parent.hasChildNodes()) {
            parent.removeChild(parent.getFirstChild());
        }
    }

    public static void removeChildrenByTagName(Element rootElement, String name) {
        Node nextChildToRemove = null;
        while (rootElement.hasChildNodes() && (nextChildToRemove = DOMContext.findChildWithNodeName(rootElement, name)) != null) {
            rootElement.removeChild(nextChildToRemove);
        }
    }

    private static Node findChildWithNodeName(Element root, String nodeName) {
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node nextChildNode = children.item(i);
            String name = nextChildNode.getNodeName();
            if (!name.equalsIgnoreCase(nodeName)) continue;
            return nextChildNode;
        }
        return null;
    }

    public static List findChildrenWithNodeName(Element root, String nodeName) {
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        ArrayList<Node> foundItems = new ArrayList<Node>();
        for (int i = 0; i < length; ++i) {
            Node nextChildNode = children.item(i);
            String name = nextChildNode.getNodeName();
            if (!name.equalsIgnoreCase(nodeName)) continue;
            foundItems.add(nextChildNode);
        }
        return foundItems;
    }
}

