/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.FileInfo;
import com.icesoft.faces.component.inputfile.InputFileProgressEvent;
import com.icesoft.faces.component.inputfile.InputFileSetFileEvent;
import com.icesoft.faces.component.inputfile.UploadConfig;
import com.icesoft.faces.component.inputfile.UploadStateHolder;
import com.icesoft.util.CoreComponentUtils;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUploadPhaseListener
implements PhaseListener {
    private static final Log log = LogFactory.getLog(FileUploadPhaseListener.class);

    public void beforePhase(PhaseEvent phaseEvent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileUploadPhaseListener.beforePhase()  " + phaseEvent.getPhaseId().toString()));
        }
        if (PhaseId.APPLY_REQUEST_VALUES == phaseEvent.getPhaseId()) {
            UploadStateHolder stateHolder = UploadStateHolder.take();
            if (log.isDebugEnabled()) {
                log.debug((Object)("FileUploadPhaseListener.beforePhase()  stateHolder: " + stateHolder));
            }
            if (stateHolder != null) {
                UploadConfig uploadConfig = stateHolder.getUploadConfig();
                FileInfo fileInfo = stateHolder.getFileInfo();
                String clientId = uploadConfig.getClientId();
                String formClientId = uploadConfig.getFormClientId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("FileUploadPhaseListener.beforePhase()  clientId: " + clientId));
                    log.debug((Object)("FileUploadPhaseListener.beforePhase()  formClientId: " + formClientId));
                    log.debug((Object)("FileUploadPhaseListener.beforePhase()  uploadConfig: " + uploadConfig));
                    log.debug((Object)("FileUploadPhaseListener.beforePhase()  fileInfo: " + fileInfo));
                }
                if (clientId != null && formClientId != null) {
                    FacesContext context = phaseEvent.getFacesContext();
                    Map parameterMap = context.getExternalContext().getRequestParameterMap();
                    parameterMap.put(clientId, stateHolder);
                    UIComponent inputFile = CoreComponentUtils.findComponent(clientId, (UIComponent)phaseEvent.getFacesContext().getViewRoot());
                    if (inputFile != null) {
                        inputFile.getAttributes().put("fileInfo", fileInfo);
                        inputFile.queueEvent((FacesEvent)new InputFileProgressEvent(inputFile));
                        if (fileInfo.isSaved()) {
                            inputFile.queueEvent((FacesEvent)new InputFileSetFileEvent(inputFile));
                        }
                        if (fileInfo.isFinished()) {
                            ActionEvent event = new ActionEvent(inputFile);
                            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
                            inputFile.queueEvent((FacesEvent)event);
                        }
                    }
                }
            }
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileUploadPhaseListener.afterPhase()  " + phaseEvent.getPhaseId().toString()));
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.APPLY_REQUEST_VALUES;
    }
}

