/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.regex;

import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ctakes.core.util.regex.ThreadString;
import org.apache.log4j.Logger;

public class TimeoutMatcher
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger((String)"TimeoutMatcher");
    private static final int DEFAULT_TIMEOUT_MILLIS = 1000;
    private static final int MIN_TIMEOUT_MILLIS = 100;
    private static final int MAX_TIMEOUT_MILLIS = 10000;
    private final ExecutorService _executor;
    private final int _timeoutMillis;
    private final Matcher _matcher;

    public TimeoutMatcher(String regex, String text) throws IllegalArgumentException {
        this(Pattern.compile(regex), text);
    }

    public TimeoutMatcher(String regex, String text, int timeoutMillis) throws IllegalArgumentException {
        this(Pattern.compile(regex), text, timeoutMillis);
    }

    public TimeoutMatcher(Pattern pattern, String text) throws IllegalArgumentException {
        this(pattern, text, 1000);
    }

    public TimeoutMatcher(Pattern pattern, String text, int timeoutMillis) throws IllegalArgumentException {
        if (pattern == null) {
            throw new PatternSyntaxException("Pattern cannot be null", "", -1);
        }
        if (timeoutMillis < 100 || timeoutMillis > 10000) {
            throw new IllegalArgumentException("Timeout must be between 100 and 10000");
        }
        this._matcher = pattern.matcher(new ThreadString(text));
        this._timeoutMillis = timeoutMillis;
        this._executor = Executors.newSingleThreadExecutor();
    }

    public Matcher nextMatch() {
        RegexCallable callable = new RegexCallable();
        Future<Matcher> future = this._executor.submit(callable);
        try {
            return future.get(this._timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException multE) {
            LOGGER.debug((Object)("Timeout for " + this._matcher.pattern()));
            if (!future.cancel(true)) {
                LOGGER.error((Object)("Timed out but could not be cancelled while detecting " + this._matcher.pattern()));
            }
            if (future.isCancelled()) {
                LOGGER.error((Object)("Cancelled while detecting " + this._matcher.pattern()));
            } else if (!future.isDone()) {
                LOGGER.error((Object)("Not cancelled but didn't complete while detecting " + this._matcher.pattern()));
            }
            return null;
        }
    }

    @Override
    public void close() {
        this._executor.shutdownNow();
    }

    private final class RegexCallable
    implements Callable<Matcher> {
        private RegexCallable() {
        }

        @Override
        public Matcher call() {
            if (TimeoutMatcher.this._matcher.find()) {
                return TimeoutMatcher.this._matcher;
            }
            return null;
        }
    }
}

