/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.core.util.collection.CollectionMap;

@Immutable
public final class ImmutableCollectionMap<K, V, T extends Collection<V>>
implements CollectionMap<K, V, T> {
    private final CollectionMap<K, V, T> _protectedMap;

    public ImmutableCollectionMap(CollectionMap<K, V, T> collectionMap) {
        this._protectedMap = collectionMap;
    }

    @Override
    public Iterator<Map.Entry<K, T>> iterator() {
        return this._protectedMap.iterator();
    }

    @Override
    public Collection<T> getAllCollections() {
        return Collections.unmodifiableCollection(this._protectedMap.values());
    }

    @Override
    public T getCollection(K key) {
        return this._protectedMap.getCollection(key);
    }

    @Override
    public T getOrCreateCollection(K key) {
        return this.getCollection(key);
    }

    @Override
    public boolean containsValue(K key, V value) {
        return this._protectedMap.containsValue(key, value);
    }

    @Override
    public boolean placeValue(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean placeMap(Map<K, V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeValue(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <C extends Collection<V>> int addAllValues(K key, C collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCollection(K key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this._protectedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._protectedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._protectedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._protectedMap.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return (T)((Collection)this._protectedMap.get(key));
    }

    @Override
    public T put(K key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends T> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this._protectedMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this._protectedMap.values();
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        return this._protectedMap.entrySet();
    }

    @Override
    public Map<K, T> toSimpleMap() {
        return Collections.unmodifiableMap(this._protectedMap);
    }
}

