/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.util.collection.CollectionCreator;
import org.apache.ctakes.core.util.collection.CollectionCreatorFactory;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.DefaultCollectionMap;

public final class ArrayListMap<K, V>
implements CollectionMap<K, V, List<V>> {
    private final CollectionMap<K, V, List<V>> _delegate;

    public ArrayListMap() {
        HashMap hashMap = new HashMap();
        CollectionCreator creator = CollectionCreatorFactory.createListCreator();
        this._delegate = new DefaultCollectionMap(hashMap, creator);
    }

    public ArrayListMap(int size) {
        HashMap hashMap = new HashMap(size);
        CollectionCreator creator = CollectionCreatorFactory.createListCreator();
        this._delegate = new DefaultCollectionMap(hashMap, creator);
    }

    @Override
    public Iterator<Map.Entry<K, List<V>>> iterator() {
        return this._delegate.iterator();
    }

    @Override
    public Collection<List<V>> getAllCollections() {
        return new HashSet<List<V>>(this._delegate.values());
    }

    @Override
    public List<V> getCollection(K key) {
        return this._delegate.getCollection(key);
    }

    @Override
    public List<V> getOrCreateCollection(K key) {
        return this._delegate.getOrCreateCollection(key);
    }

    @Override
    public boolean containsValue(K key, V value) {
        return this._delegate.containsValue(key, value);
    }

    @Override
    public boolean placeValue(K key, V value) {
        return this._delegate.placeValue(key, value);
    }

    @Override
    public boolean placeMap(Map<K, V> map) {
        return this._delegate.placeMap(map);
    }

    @Override
    public void removeValue(K key, V value) {
        this._delegate.removeValue(key, value);
    }

    @Override
    public <C extends Collection<V>> int addAllValues(K key, C collection) {
        return this._delegate.addAllValues(key, collection);
    }

    @Override
    public void clearCollection(K key) {
        this._delegate.clearCollection(key);
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._delegate.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return (List)this._delegate.get(key);
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this._delegate.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return (List)this._delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        this._delegate.putAll(map);
    }

    @Override
    public void clear() {
        this._delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._delegate.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this._delegate.values();
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this._delegate.entrySet();
    }

    @Override
    public Map<K, List<V>> toSimpleMap() {
        return this._delegate;
    }
}

