/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Pair<T> {
    private final T _value1;
    private final T _value2;

    public Pair(@Nonnull T value1, @Nonnull T value2) {
        if (value1 == null || value2 == null) {
            throw new NullPointerException("Cannot pass null value to Pair: " + value1 + "," + value2);
        }
        this._value1 = value1;
        this._value2 = value2;
    }

    public T getValue1() {
        return this._value1;
    }

    public T getValue2() {
        return this._value2;
    }

    public String toString() {
        return this._value1.toString() + "," + this._value2.toString();
    }

    public int hashCode() {
        return this._value1.hashCode() + 13 * this._value2.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Pair && ((Pair)other)._value1.equals(this._value1) && ((Pair)other)._value2.equals(this._value2);
    }
}

