/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.output.RomanNumeralToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;
import org.apache.ctakes.core.fsm.token.WordToken;

public class RomanNumeralFSM {
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public RomanNumeralFSM() {
        this.iv_machineSet.add(this.getMachine());
    }

    private Machine getMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        startState.addTransition(new RomanNumeralCondition(), endState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<RomanNumeralToken> execute(List<? extends BaseToken> tokens) throws Exception {
        HashSet<RomanNumeralToken> romanNumeralSet = new HashSet<RomanNumeralToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                RomanNumeralToken rnToken = new RomanNumeralToken(startToken.getStartOffset(), endToken.getEndOffset());
                romanNumeralSet.add(rnToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return romanNumeralSet;
    }

    class RomanNumeralCondition
    extends Condition {
        RomanNumeralCondition() {
        }

        public boolean satisfiedBy(Object conditional) {
            if (conditional instanceof WordToken) {
                WordToken wt = (WordToken)conditional;
                return this.isRomanNumeral(wt.getText());
            }
            return false;
        }

        private boolean isRomanNumeral(String str) {
            str = str.toUpperCase();
            for (int i = 0; i < str.length(); ++i) {
                char currentChar = str.charAt(i);
                if (currentChar == 'I' || currentChar == 'V' || currentChar == 'X' || currentChar == 'L' || currentChar == 'C' || currentChar == 'D' || currentChar == 'M') continue;
                return false;
            }
            return true;
        }
    }
}

