/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.fsm.machine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.IntegerCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.condition.RomanNumeralCondition;
import org.apache.ctakes.core.fsm.condition.WordSetCondition;
import org.apache.ctakes.core.fsm.output.RangeToken;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;

public class RangeFSM {
    Set<String> iv_textNumberSet = new HashSet<String>();
    private Set<Machine> iv_machineSet = new HashSet<Machine>();

    public RangeFSM() {
        this.iv_textNumberSet.add("one");
        this.iv_textNumberSet.add("two");
        this.iv_textNumberSet.add("three");
        this.iv_textNumberSet.add("four");
        this.iv_textNumberSet.add("five");
        this.iv_textNumberSet.add("six");
        this.iv_textNumberSet.add("seven");
        this.iv_textNumberSet.add("eight");
        this.iv_textNumberSet.add("nine");
        this.iv_textNumberSet.add("ten");
        this.iv_machineSet.add(this.getMachine());
    }

    private Machine getMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState leftNumIntegerState = new NamedState("LEFT_NUM_INTEGER");
        NamedState leftNumRomanState = new NamedState("LEFT_NUM_ROMAN");
        NamedState leftNumTextState = new NamedState("LEFT_NUM_TEXT");
        NamedState dashState = new NamedState("DASH");
        IntegerCondition leftIntCondition = new IntegerCondition();
        IntegerCondition rightIntCondition = new IntegerCondition();
        PunctuationValueCondition dashCondition = new PunctuationValueCondition('-');
        RomanNumeralCondition leftRomanNumeralCondition = new RomanNumeralCondition();
        RomanNumeralCondition rightRomanNumeralCondition = new RomanNumeralCondition();
        WordSetCondition leftNumTextCondition = new WordSetCondition(this.iv_textNumberSet, false);
        WordSetCondition rightNumTextCondition = new WordSetCondition(this.iv_textNumberSet, false);
        startState.addTransition(leftIntCondition, leftNumIntegerState);
        startState.addTransition(leftRomanNumeralCondition, leftNumRomanState);
        startState.addTransition(leftNumTextCondition, leftNumTextState);
        startState.addTransition((Condition)new AnyCondition(), startState);
        leftNumIntegerState.addTransition(dashCondition, dashState);
        leftNumIntegerState.addTransition((Condition)new AnyCondition(), startState);
        leftNumRomanState.addTransition(dashCondition, dashState);
        leftNumRomanState.addTransition((Condition)new AnyCondition(), startState);
        leftNumTextState.addTransition(dashCondition, dashState);
        leftNumTextState.addTransition((Condition)new AnyCondition(), startState);
        dashState.addTransition(rightIntCondition, endState);
        dashState.addTransition(rightRomanNumeralCondition, endState);
        dashState.addTransition(rightNumTextCondition, endState);
        dashState.addTransition((Condition)new AnyCondition(), startState);
        endState.addTransition((Condition)new AnyCondition(), startState);
        return m;
    }

    public Set<RangeToken> execute(List<? extends BaseToken> tokens, Set<? extends BaseToken> overrideSet) throws Exception {
        HashSet<RangeToken> rangeSet = new HashSet<RangeToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        Iterator<? extends BaseToken> overrideTokenItr = overrideSet.iterator();
        HashMap<Integer, BaseToken> overrideTokenMap = new HashMap<Integer, BaseToken>();
        while (overrideTokenItr.hasNext()) {
            BaseToken t = overrideTokenItr.next();
            Integer key = new Integer(t.getStartOffset());
            overrideTokenMap.put(key, t);
        }
        boolean overrideOn = false;
        int overrideEndOffset = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = tokens.get(i);
            Integer key = new Integer(token.getStartOffset());
            if (overrideOn) {
                if (token.getStartOffset() < overrideEndOffset) continue;
                overrideOn = false;
                overrideEndOffset = -1;
            } else if (overrideTokenMap.containsKey(key)) {
                token = (BaseToken)overrideTokenMap.get(key);
                overrideOn = true;
                overrideEndOffset = token.getEndOffset();
            }
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, new Integer(i));
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                RangeToken rangeToken = new RangeToken(startToken.getStartOffset(), endToken.getEndOffset());
                rangeSet.add(rangeToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return rangeSet;
    }
}

