/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cpe;

import java.io.IOException;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class CmdLineCpeRunner {
    public static void main(String[] args) {
        if (args.length == 0 || args[0].isEmpty()) {
            System.err.println("Please provide the path to a cpe.xml in the first argument.\nIf you do not have a cpe.xml you can create one with the cpe gui.");
            System.exit(1);
        }
        XMLInputSource xmlInputSource = null;
        try {
            xmlInputSource = new XMLInputSource(args[0]);
        }
        catch (IOException ioE) {
            System.err.println("Couldn't open cpe xml " + args[0]);
            System.err.println("  " + ioE.getLocalizedMessage());
            System.exit(1);
        }
        CpeDescription cpeDescription = null;
        try {
            cpeDescription = UIMAFramework.getXMLParser().parseCpeDescription(xmlInputSource);
        }
        catch (InvalidXMLException ixmlE) {
            System.err.println("Couldn't parse cpe xml " + args[0]);
            System.err.println("  " + ixmlE.getLocalizedMessage());
            System.exit(1);
        }
        CollectionProcessingEngine collectionProcessingEngine = null;
        try {
            collectionProcessingEngine = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)cpeDescription);
        }
        catch (ResourceInitializationException riE) {
            System.err.println("Couldn't initialize processing engine.");
            System.err.println("  " + riE.getLocalizedMessage());
            System.exit(1);
        }
        collectionProcessingEngine.addStatusCallbackListener((StatusCallbackListener)new MyStatusCallbackListener());
        try {
            collectionProcessingEngine.process();
        }
        catch (ResourceInitializationException riE) {
            System.err.println("Couldn't Run processing engine.");
            System.err.println("  " + riE.getLocalizedMessage());
            System.exit(1);
        }
    }

    private static class MyStatusCallbackListener
    implements StatusCallbackListener {
        private long mStartTime = System.currentTimeMillis();
        private long mInitCompleteTime;
        int entityCount = 0;
        long size = 0L;

        private MyStatusCallbackListener() {
        }

        public void initializationComplete() {
            System.out.println("CPM Initialization Complete");
            this.mInitCompleteTime = System.currentTimeMillis();
        }

        public void batchProcessComplete() {
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long elapsedTime = System.currentTimeMillis() - this.mStartTime;
            System.out.println("Time Elapsed : " + elapsedTime + " ms ");
        }

        public void collectionProcessComplete() {
            long time = System.currentTimeMillis();
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long initTime = this.mInitCompleteTime - this.mStartTime;
            long processingTime = time - this.mInitCompleteTime;
            long elapsedTime = initTime + processingTime;
            System.out.println("Total Time Elapsed: " + elapsedTime + " ms ");
            System.out.println("Initialization Time: " + initTime + " ms");
            System.out.println("Processing Time: " + processingTime + " ms");
            System.out.println("\n\n ------------------ PERFORMANCE REPORT ------------------\n");
        }

        public void paused() {
            System.out.println("Paused");
        }

        public void resumed() {
            System.out.println("Resumed");
        }

        public void aborted() {
            System.out.println("Aborted");
            System.exit(1);
        }

        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
            if (aStatus.isException()) {
                List exceptions = aStatus.getExceptions();
                for (Exception exception : exceptions) {
                    exception.printStackTrace();
                }
                return;
            }
            ++this.entityCount;
            String docText = aCas.getDocumentText();
            if (docText != null) {
                this.size += (long)docText.length();
            }
        }
    }
}

